/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.BKDConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.HeapPointReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.PointReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.PointValue;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.PointWriter;

public final class HeapPointWriter
implements PointWriter {
    private final byte[] block;
    final int size;
    private final BKDConfig config;
    private final byte[] scratch;
    private final ArrayUtil.ByteArrayComparator dimComparator;
    private final int dataDimsAndDocLength;
    private int nextWrite;
    private boolean closed;
    private final HeapPointValue pointValue;

    public HeapPointWriter(BKDConfig config, int size) {
        this.config = config;
        this.block = new byte[config.bytesPerDoc * size];
        this.size = size;
        this.dimComparator = ArrayUtil.getUnsignedComparator(config.bytesPerDim);
        this.dataDimsAndDocLength = config.bytesPerDoc - config.packedIndexBytesLength;
        this.scratch = new byte[config.bytesPerDoc];
        this.pointValue = size > 0 ? new HeapPointValue(config, this.block) : null;
    }

    public PointValue getPackedValueSlice(int index) {
        assert (index < this.nextWrite) : "nextWrite=" + this.nextWrite + " vs index=" + index;
        this.pointValue.setOffset(index * this.config.bytesPerDoc);
        return this.pointValue;
    }

    @Override
    public void append(byte[] packedValue, int docID) {
        assert (!this.closed) : "point writer is already closed";
        assert (packedValue.length == this.config.packedBytesLength) : "[packedValue] must have length [" + this.config.packedBytesLength + "] but was [" + packedValue.length + "]";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        int position = this.nextWrite * this.config.bytesPerDoc;
        System.arraycopy(packedValue, 0, this.block, position, this.config.packedBytesLength);
        BitUtil.VH_BE_INT.set(this.block, position + this.config.packedBytesLength, docID);
        ++this.nextWrite;
    }

    @Override
    public void append(PointValue pointValue) {
        assert (!this.closed) : "point writer is already closed";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        assert (packedValueDocID.length == this.config.bytesPerDoc) : "[packedValue] must have length [" + this.config.bytesPerDoc + "] but was [" + packedValueDocID.length + "]";
        int position = this.nextWrite * this.config.bytesPerDoc;
        System.arraycopy(packedValueDocID.bytes, packedValueDocID.offset, this.block, position, this.config.bytesPerDoc);
        ++this.nextWrite;
    }

    void swap(int i, int j) {
        int indexI = i * this.config.bytesPerDoc;
        int indexJ = j * this.config.bytesPerDoc;
        System.arraycopy(this.block, indexI, this.scratch, 0, this.config.bytesPerDoc);
        System.arraycopy(this.block, indexJ, this.block, indexI, this.config.bytesPerDoc);
        System.arraycopy(this.scratch, 0, this.block, indexJ, this.config.bytesPerDoc);
    }

    int byteAt(int i, int k) {
        return this.block[i * this.config.bytesPerDoc + k] & 0xFF;
    }

    void copyDim(int i, int dim, byte[] bytes, int offset) {
        System.arraycopy(this.block, i * this.config.bytesPerDoc + dim, bytes, offset, this.config.bytesPerDim);
    }

    void copyDataDimsAndDoc(int i, byte[] bytes, int offset) {
        System.arraycopy(this.block, i * this.config.bytesPerDoc + this.config.packedIndexBytesLength, bytes, offset, this.dataDimsAndDocLength);
    }

    int compareDim(int i, int j, int dim) {
        int iOffset = i * this.config.bytesPerDoc + dim;
        int jOffset = j * this.config.bytesPerDoc + dim;
        return this.compareDim(this.block, iOffset, this.block, jOffset);
    }

    int compareDim(int j, byte[] dimValue, int offset, int dim) {
        int jOffset = j * this.config.bytesPerDoc + dim;
        return this.compareDim(dimValue, offset, this.block, jOffset);
    }

    private int compareDim(byte[] blockI, int offsetI, byte[] blockJ, int offsetJ) {
        return this.dimComparator.compare(blockI, offsetI, blockJ, offsetJ);
    }

    int compareDataDimsAndDoc(int i, int j) {
        int iOffset = i * this.config.bytesPerDoc + this.config.packedIndexBytesLength;
        int jOffset = j * this.config.bytesPerDoc + this.config.packedIndexBytesLength;
        return this.compareDataDimsAndDoc(this.block, iOffset, this.block, jOffset);
    }

    int compareDataDimsAndDoc(int j, byte[] dataDimsAndDocs, int offset) {
        int jOffset = j * this.config.bytesPerDoc + this.config.packedIndexBytesLength;
        return this.compareDataDimsAndDoc(dataDimsAndDocs, offset, this.block, jOffset);
    }

    private int compareDataDimsAndDoc(byte[] blockI, int offsetI, byte[] blockJ, int offsetJ) {
        return Arrays.compareUnsigned(blockI, offsetI, offsetI + this.dataDimsAndDocLength, blockJ, offsetJ, offsetJ + this.dataDimsAndDocLength);
    }

    public int computeCardinality(int from, int to, int[] commonPrefixLengths) {
        int leafCardinality = 1;
        block0: for (int i = from + 1; i < to; ++i) {
            int pointOffset = (i - 1) * this.config.bytesPerDoc;
            int nextPointOffset = pointOffset + this.config.bytesPerDoc;
            for (int dim = 0; dim < this.config.numDims; ++dim) {
                int start = dim * this.config.bytesPerDim + commonPrefixLengths[dim];
                int end = dim * this.config.bytesPerDim + this.config.bytesPerDim;
                if (Arrays.mismatch(this.block, nextPointOffset + start, nextPointOffset + end, this.block, pointOffset + start, pointOffset + end) == -1) continue;
                ++leafCardinality;
                continue block0;
            }
        }
        return leafCardinality;
    }

    @Override
    public long count() {
        return this.nextWrite;
    }

    @Override
    public PointReader getReader(long start, long length) {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= (long)this.size) : "start=" + start + " length=" + length + " docIDs.length=" + this.size;
        assert (start + length <= (long)this.nextWrite) : "start=" + start + " length=" + length + " nextWrite=" + this.nextWrite;
        return new HeapPointReader(this::getPackedValueSlice, (int)start, Math.toIntExact(start + length));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " size=" + this.size + ")";
    }

    private static class HeapPointValue
    implements PointValue {
        private final BytesRef packedValue;
        private final BytesRef packedValueDocID;
        private final int packedValueLength;

        HeapPointValue(BKDConfig config, byte[] value) {
            this.packedValueLength = config.packedBytesLength;
            this.packedValue = new BytesRef(value, 0, this.packedValueLength);
            this.packedValueDocID = new BytesRef(value, 0, config.bytesPerDoc);
        }

        void setOffset(int offset) {
            this.packedValue.offset = offset;
            this.packedValueDocID.offset = offset;
        }

        @Override
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.offset + this.packedValueLength;
            return BitUtil.VH_BE_INT.get(this.packedValueDocID.bytes, position);
        }

        @Override
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

