/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

public class XYZBounds
implements Bounds {
    private static final double FUDGE_FACTOR = 1.0E-9;
    private Double minX = null;
    private Double maxX = null;
    private Double minY = null;
    private Double maxY = null;
    private Double minZ = null;
    private Double maxZ = null;

    public Double getMinimumX() {
        return this.minX;
    }

    public Double getMaximumX() {
        return this.maxX;
    }

    public Double getMinimumY() {
        return this.minY;
    }

    public Double getMaximumY() {
        return this.maxY;
    }

    public Double getMinimumZ() {
        return this.minZ;
    }

    public Double getMaximumZ() {
        return this.maxZ;
    }

    public boolean isSmallestMinX(PlanetModel planetModel) {
        if (this.minX == null) {
            return false;
        }
        return this.minX - planetModel.getMinimumXValue() < 1.0E-12;
    }

    public boolean isLargestMaxX(PlanetModel planetModel) {
        if (this.maxX == null) {
            return false;
        }
        return planetModel.getMaximumXValue() - this.maxX < 1.0E-12;
    }

    public boolean isSmallestMinY(PlanetModel planetModel) {
        if (this.minY == null) {
            return false;
        }
        return this.minY - planetModel.getMinimumYValue() < 1.0E-12;
    }

    public boolean isLargestMaxY(PlanetModel planetModel) {
        if (this.maxY == null) {
            return false;
        }
        return planetModel.getMaximumYValue() - this.maxY < 1.0E-12;
    }

    public boolean isSmallestMinZ(PlanetModel planetModel) {
        if (this.minZ == null) {
            return false;
        }
        return this.minZ - planetModel.getMinimumZValue() < 1.0E-12;
    }

    public boolean isLargestMaxZ(PlanetModel planetModel) {
        if (this.maxZ == null) {
            return false;
        }
        return planetModel.getMaximumZValue() - this.maxZ < 1.0E-12;
    }

    public boolean overlaps(XYZBounds bounds) {
        return XYZBounds.isCornerInside(this, bounds) || XYZBounds.isCornerInside(bounds, this);
    }

    private static boolean isCornerInside(XYZBounds one, XYZBounds other) {
        if (one.minX == null || one.maxX == null || one.minY == null || one.maxY == null || one.minZ == null || one.maxZ == null) {
            return false;
        }
        if (other.minX == null || other.maxX == null || other.minY == null || other.maxY == null || other.minZ == null || other.maxZ == null) {
            return false;
        }
        return XYZBounds.isPointInside(other, one.minX, one.minY, one.minZ) || XYZBounds.isPointInside(other, one.maxX, one.minY, one.minZ) || XYZBounds.isPointInside(other, one.minX, one.maxY, one.minZ) || XYZBounds.isPointInside(other, one.maxX, one.maxY, one.minZ) || XYZBounds.isPointInside(other, one.minX, one.minY, one.maxZ) || XYZBounds.isPointInside(other, one.maxX, one.minY, one.maxZ) || XYZBounds.isPointInside(other, one.minX, one.maxY, one.maxZ) || XYZBounds.isPointInside(other, one.maxX, one.maxY, one.maxZ);
    }

    private static boolean isPointInside(XYZBounds other, double x, double y, double z) {
        return other.minX <= x && other.maxX >= x && other.minY <= y && other.maxY >= y && other.minZ <= z && other.maxZ >= z;
    }

    public void addBounds(XYZBounds bounds) {
        if (bounds.maxX == null || this.maxX > bounds.maxX) {
            bounds.maxX = this.maxX;
        }
        if (bounds.minX == null || this.minX < bounds.minX) {
            bounds.minX = this.minX;
        }
        if (bounds.maxY == null || this.maxY > bounds.maxY) {
            bounds.maxY = this.maxY;
        }
        if (bounds.minY == null || this.minY < bounds.minY) {
            bounds.minY = this.minY;
        }
        if (bounds.maxZ == null || this.maxZ > bounds.maxZ) {
            bounds.maxZ = this.maxZ;
        }
        if (bounds.minZ == null || this.minZ < bounds.minZ) {
            bounds.minZ = this.minZ;
        }
    }

    @Override
    public Bounds addPlane(PlanetModel planetModel, Plane plane, Membership ... bounds) {
        plane.recordBounds(planetModel, this, bounds);
        return this;
    }

    @Override
    public Bounds addHorizontalPlane(PlanetModel planetModel, double latitude, Plane horizontalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, horizontalPlane, bounds);
    }

    @Override
    public Bounds addVerticalPlane(PlanetModel planetModel, double longitude, Plane verticalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, verticalPlane, bounds);
    }

    @Override
    public Bounds addXValue(GeoPoint point) {
        return this.addXValue(point.x);
    }

    public Bounds addXValue(double x) {
        double small = x - 1.0E-9;
        if (this.minX == null || this.minX > small) {
            this.minX = small;
        }
        double large = x + 1.0E-9;
        if (this.maxX == null || this.maxX < large) {
            this.maxX = large;
        }
        return this;
    }

    @Override
    public Bounds addYValue(GeoPoint point) {
        return this.addYValue(point.y);
    }

    public Bounds addYValue(double y) {
        double small = y - 1.0E-9;
        if (this.minY == null || this.minY > small) {
            this.minY = small;
        }
        double large = y + 1.0E-9;
        if (this.maxY == null || this.maxY < large) {
            this.maxY = large;
        }
        return this;
    }

    @Override
    public Bounds addZValue(GeoPoint point) {
        return this.addZValue(point.z);
    }

    public Bounds addZValue(double z) {
        double small = z - 1.0E-9;
        if (this.minZ == null || this.minZ > small) {
            this.minZ = small;
        }
        double large = z + 1.0E-9;
        if (this.maxZ == null || this.maxZ < large) {
            this.maxZ = large;
        }
        return this;
    }

    @Override
    public Bounds addIntersection(PlanetModel planetModel, Plane plane1, Plane plane2, Membership ... bounds) {
        plane1.recordBounds(planetModel, this, plane2, bounds);
        return this;
    }

    @Override
    public Bounds addPoint(GeoPoint point) {
        return this.addXValue(point).addYValue(point).addZValue(point);
    }

    @Override
    public Bounds isWide() {
        return this;
    }

    @Override
    public Bounds noLongitudeBound() {
        return this;
    }

    @Override
    public Bounds noTopLatitudeBound() {
        return this;
    }

    @Override
    public Bounds noBottomLatitudeBound() {
        return this;
    }

    @Override
    public Bounds noBound(PlanetModel planetModel) {
        this.minX = planetModel.getMinimumXValue();
        this.maxX = planetModel.getMaximumXValue();
        this.minY = planetModel.getMinimumYValue();
        this.maxY = planetModel.getMaximumYValue();
        this.minZ = planetModel.getMinimumZValue();
        this.maxZ = planetModel.getMaximumZValue();
        return this;
    }

    public boolean isWithin(Vector v) {
        return this.isWithin(v.x, v.y, v.z);
    }

    public boolean isWithin(double x, double y, double z) {
        return this.minX != null && x >= this.minX && this.maxX != null && x <= this.maxX && this.minY != null && y >= this.minY && this.maxY != null && y <= this.maxY && this.minZ != null && z >= this.minZ && this.maxZ != null && z <= this.maxZ;
    }

    public String toString() {
        return "XYZBounds: [xmin=" + this.minX + " xmax=" + this.maxX + " ymin=" + this.minY + " ymax=" + this.maxY + " zmin=" + this.minZ + " zmax=" + this.maxZ + "]";
    }
}

