/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities;

import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInvertState;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectionStatistics;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermStatistics;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.BM25Similarity;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Similarity;

public class BooleanSimilarity
extends Similarity {
    private static final Similarity BM25_SIM = new BM25Similarity();

    @Override
    public long computeNorm(FieldInvertState state) {
        return BM25_SIM.computeNorm(state);
    }

    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    private static class BooleanWeight
    extends Similarity.SimScorer {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }

        @Override
        public float score(float freq, long norm) {
            return this.boost;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            Explanation queryBoostExpl = Explanation.match((Number)Float.valueOf(this.boost), "boost, query boost", new Explanation[0]);
            return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + "), computed from:", queryBoostExpl);
        }
    }
}

