/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping;

import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping.GroupDocs;

public class TopGroups<T> {
    public final int totalHitCount;
    public final int totalGroupedHitCount;
    public final Integer totalGroupCount;
    public final GroupDocs<T>[] groups;
    public final SortField[] groupSort;
    public final SortField[] withinGroupSort;
    public final float maxScore;

    public TopGroups(SortField[] groupSort, SortField[] withinGroupSort, int totalHitCount, int totalGroupedHitCount, GroupDocs<T>[] groups, float maxScore) {
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.totalHitCount = totalHitCount;
        this.totalGroupedHitCount = totalGroupedHitCount;
        this.groups = groups;
        this.totalGroupCount = null;
        this.maxScore = maxScore;
    }

    public TopGroups(TopGroups<T> oldTopGroups, Integer totalGroupCount) {
        this.groupSort = oldTopGroups.groupSort;
        this.withinGroupSort = oldTopGroups.withinGroupSort;
        this.totalHitCount = oldTopGroups.totalHitCount;
        this.totalGroupedHitCount = oldTopGroups.totalGroupedHitCount;
        this.groups = oldTopGroups.groups;
        this.maxScore = oldTopGroups.maxScore;
        this.totalGroupCount = totalGroupCount;
    }

    private static float nonNANmax(float a, float b) {
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    public static <T> TopGroups<T> merge(TopGroups<T>[] shardGroups, Sort groupSort, Sort docSort, int docOffset, int docTopN, ScoreMergeMode scoreMergeMode) {
        if (shardGroups.length == 0) {
            return null;
        }
        int totalHitCount = 0;
        int totalGroupedHitCount = 0;
        Integer totalGroupCount = null;
        int numGroups = shardGroups[0].groups.length;
        for (TopGroups<T> shard : shardGroups) {
            if (numGroups != shard.groups.length) {
                throw new IllegalArgumentException("number of groups differs across shards; you must pass same top groups to all shards' second-pass collector");
            }
            totalHitCount += shard.totalHitCount;
            totalGroupedHitCount += shard.totalGroupedHitCount;
            if (shard.totalGroupCount == null) continue;
            if (totalGroupCount == null) {
                totalGroupCount = 0;
            }
            totalGroupCount = totalGroupCount + shard.totalGroupCount;
        }
        GroupDocs[] mergedGroupDocs = new GroupDocs[numGroups];
        TopDocs[] shardTopDocs = docSort.equals(Sort.RELEVANCE) ? new TopDocs[shardGroups.length] : new TopFieldDocs[shardGroups.length];
        float totalMaxScore = Float.NaN;
        for (int groupIDX = 0; groupIDX < numGroups; ++groupIDX) {
            float groupScore;
            ScoreDoc[] mergedScoreDocs;
            Object groupValue = shardGroups[0].groups[groupIDX].groupValue;
            float maxScore = Float.NaN;
            int totalHits = 0;
            double scoreSum = 0.0;
            for (int shardIDX = 0; shardIDX < shardGroups.length; ++shardIDX) {
                TopGroups<T> shard = shardGroups[shardIDX];
                GroupDocs<T> shardGroupDocs = shard.groups[groupIDX];
                if (groupValue == null ? shardGroupDocs.groupValue != null : !groupValue.equals(shardGroupDocs.groupValue)) {
                    throw new IllegalArgumentException("group values differ across shards; you must pass same top groups to all shards' second-pass collector");
                }
                shardTopDocs[shardIDX] = docSort.equals(Sort.RELEVANCE) ? new TopDocs(shardGroupDocs.totalHits, shardGroupDocs.scoreDocs) : new TopFieldDocs(shardGroupDocs.totalHits, shardGroupDocs.scoreDocs, docSort.getSort());
                for (int i = 0; i < shardTopDocs[shardIDX].scoreDocs.length; ++i) {
                    shardTopDocs[shardIDX].scoreDocs[i].shardIndex = shardIDX;
                }
                maxScore = TopGroups.nonNANmax(maxScore, shardGroupDocs.maxScore);
                assert (shardGroupDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
                totalHits = (int)((long)totalHits + shardGroupDocs.totalHits.value);
                scoreSum += (double)shardGroupDocs.score;
            }
            TopDocs mergedTopDocs = docSort.equals(Sort.RELEVANCE) ? TopDocs.merge(docOffset + docTopN, shardTopDocs) : TopDocs.merge(docSort, docOffset + docTopN, (TopFieldDocs[])shardTopDocs);
            if (docOffset == 0) {
                mergedScoreDocs = mergedTopDocs.scoreDocs;
            } else if (docOffset >= mergedTopDocs.scoreDocs.length) {
                mergedScoreDocs = new ScoreDoc[]{};
            } else {
                mergedScoreDocs = new ScoreDoc[mergedTopDocs.scoreDocs.length - docOffset];
                System.arraycopy(mergedTopDocs.scoreDocs, docOffset, mergedScoreDocs, 0, mergedTopDocs.scoreDocs.length - docOffset);
            }
            switch (scoreMergeMode) {
                case None: {
                    groupScore = Float.NaN;
                    break;
                }
                case Avg: {
                    if (totalHits > 0) {
                        groupScore = (float)(scoreSum / (double)totalHits);
                        break;
                    }
                    groupScore = Float.NaN;
                    break;
                }
                case Total: {
                    groupScore = (float)scoreSum;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't handle ScoreMergeMode " + scoreMergeMode);
                }
            }
            mergedGroupDocs[groupIDX] = new GroupDocs(groupScore, maxScore, new TotalHits(totalHits, TotalHits.Relation.EQUAL_TO), mergedScoreDocs, groupValue, shardGroups[0].groups[groupIDX].groupSortValues);
            totalMaxScore = TopGroups.nonNANmax(totalMaxScore, maxScore);
        }
        if (totalGroupCount != null) {
            TopGroups<T> result = new TopGroups<T>(groupSort.getSort(), docSort.getSort(), totalHitCount, totalGroupedHitCount, mergedGroupDocs, totalMaxScore);
            return new TopGroups<T>(result, totalGroupCount);
        }
        return new TopGroups<T>(groupSort.getSort(), docSort.getSort(), totalHitCount, totalGroupedHitCount, mergedGroupDocs, totalMaxScore);
    }

    public static enum ScoreMergeMode {
        None,
        Total,
        Avg;

    }
}

