/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.comparators;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Pruning;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.DocIdSetBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NumericUtils;

public abstract class NumericComparator<T extends Number>
extends FieldComparator<T> {
    private static final int MIN_SKIP_INTERVAL = 32;
    private static final int MAX_SKIP_INTERVAL = 8192;
    protected final T missingValue;
    protected final String field;
    protected final boolean reverse;
    private final int bytesCount;
    private final ArrayUtil.ByteArrayComparator bytesComparator;
    protected boolean topValueSet;
    protected boolean singleSort;
    protected boolean hitsThresholdReached;
    protected boolean queueFull;
    protected Pruning pruning;

    protected NumericComparator(String field, T missingValue, boolean reverse, Pruning pruning, int bytesCount) {
        this.field = field;
        this.missingValue = missingValue;
        this.reverse = reverse;
        this.pruning = pruning;
        this.bytesCount = bytesCount;
        this.bytesComparator = ArrayUtil.getUnsignedComparator(bytesCount);
    }

    @Override
    public void setTopValue(T value) {
        this.topValueSet = true;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public void disableSkipping() {
        this.pruning = Pruning.NONE;
    }

    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        private final LeafReaderContext context;
        protected final NumericDocValues docValues;
        private final PointValues pointValues;
        private final boolean enableSkipping;
        private final int maxDoc;
        private byte[] minValueAsBytes;
        private byte[] maxValueAsBytes;
        private DocIdSetIterator competitiveIterator;
        private long iteratorCost = -1L;
        private int maxDocVisited = -1;
        private int updateCounter = 0;
        private int currentSkipInterval = 32;
        private int tryUpdateFailCount = 0;

        public NumericLeafComparator(LeafReaderContext context) throws IOException {
            this.context = context;
            this.docValues = this.getNumericDocValues(context, NumericComparator.this.field);
            PointValues pointValues = this.pointValues = NumericComparator.this.pruning != Pruning.NONE ? context.reader().getPointValues(NumericComparator.this.field) : null;
            if (this.pointValues != null) {
                FieldInfo info = context.reader().getFieldInfos().fieldInfo(NumericComparator.this.field);
                if (info == null || info.getPointDimensionCount() == 0) {
                    throw new IllegalStateException("Field " + NumericComparator.this.field + " doesn't index points according to FieldInfos yet returns non-null PointValues");
                }
                if (info.getPointDimensionCount() > 1) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with multiple dimensions, sorting is not supported");
                }
                if (info.getPointNumBytes() != NumericComparator.this.bytesCount) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + NumericComparator.this + " expected " + NumericComparator.this.bytesCount);
                }
                this.enableSkipping = true;
                this.maxDoc = context.reader().maxDoc();
                this.competitiveIterator = DocIdSetIterator.all(this.maxDoc);
            } else {
                this.enableSkipping = false;
                this.maxDoc = 0;
            }
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValues.getNumeric(context.reader(), field);
        }

        @Override
        public void setBottom(int slot) throws IOException {
            NumericComparator.this.queueFull = true;
            this.updateCompetitiveIterator();
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.maxDocVisited = doc;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.iteratorCost == -1L) {
                this.iteratorCost = scorer instanceof Scorer ? ((Scorer)scorer).iterator().cost() : (long)this.maxDoc;
                this.updateCompetitiveIterator();
            }
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            NumericComparator.this.hitsThresholdReached = true;
            this.updateCompetitiveIterator();
        }

        private void updateCompetitiveIterator() throws IOException {
            if (!this.enableSkipping || !NumericComparator.this.hitsThresholdReached || !NumericComparator.this.queueFull && !NumericComparator.this.topValueSet) {
                return;
            }
            if (this.pointValues.getDocCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            ++this.updateCounter;
            if (this.updateCounter > 256 && (this.updateCounter & this.currentSkipInterval - 1) != this.currentSkipInterval - 1) {
                return;
            }
            if (!NumericComparator.this.reverse) {
                if (NumericComparator.this.queueFull) {
                    this.maxValueAsBytes = this.maxValueAsBytes == null ? new byte[NumericComparator.this.bytesCount] : this.maxValueAsBytes;
                    this.encodeBottom();
                }
                if (NumericComparator.this.topValueSet) {
                    this.minValueAsBytes = this.minValueAsBytes == null ? new byte[NumericComparator.this.bytesCount] : this.minValueAsBytes;
                    this.encodeTop();
                }
            } else {
                if (NumericComparator.this.queueFull) {
                    this.minValueAsBytes = this.minValueAsBytes == null ? new byte[NumericComparator.this.bytesCount] : this.minValueAsBytes;
                    this.encodeBottom();
                }
                if (NumericComparator.this.topValueSet) {
                    this.maxValueAsBytes = this.maxValueAsBytes == null ? new byte[NumericComparator.this.bytesCount] : this.maxValueAsBytes;
                    this.encodeTop();
                }
            }
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    int cmp;
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    if (NumericLeafComparator.this.maxValueAsBytes != null && (cmp = NumericComparator.this.bytesComparator.compare(packedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0)) > 0) {
                        return;
                    }
                    if (NumericLeafComparator.this.minValueAsBytes != null && (cmp = NumericComparator.this.bytesComparator.compare(packedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0)) < 0) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    int cmp;
                    if (NumericLeafComparator.this.maxValueAsBytes != null && (cmp = NumericComparator.this.bytesComparator.compare(minPackedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0)) > 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (NumericLeafComparator.this.minValueAsBytes != null && (cmp = NumericComparator.this.bytesComparator.compare(maxPackedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0)) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (NumericLeafComparator.this.maxValueAsBytes != null && NumericComparator.this.bytesComparator.compare(maxPackedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0) > 0 || NumericLeafComparator.this.minValueAsBytes != null && NumericComparator.this.bytesComparator.compare(minPackedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0) < 0) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long threshold = this.iteratorCost >>> 3;
            long estimatedNumberOfMatches = this.pointValues.estimatePointCount(visitor);
            if (estimatedNumberOfMatches >= threshold) {
                this.updateSkipInterval(false);
                if ((long)this.pointValues.getDocCount() < this.iteratorCost) {
                    this.competitiveIterator = this.getNumericDocValues(this.context, NumericComparator.this.field);
                    this.iteratorCost = this.pointValues.getDocCount();
                }
                return;
            }
            this.pointValues.intersect(visitor);
            this.competitiveIterator = result.build().iterator();
            this.iteratorCost = this.competitiveIterator.cost();
            this.updateSkipInterval(true);
        }

        private void updateSkipInterval(boolean success) {
            if (this.updateCounter > 256) {
                if (success) {
                    this.currentSkipInterval = Math.max(this.currentSkipInterval / 2, 32);
                    this.tryUpdateFailCount = 0;
                } else if (this.tryUpdateFailCount >= 3) {
                    this.currentSkipInterval = Math.min(this.currentSkipInterval * 2, 8192);
                    this.tryUpdateFailCount = 0;
                } else {
                    ++this.tryUpdateFailCount;
                }
            }
        }

        private void encodeBottom() {
            if (!NumericComparator.this.reverse) {
                this.encodeBottom(this.maxValueAsBytes);
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO) {
                    NumericUtils.nextDown(this.maxValueAsBytes);
                }
            } else {
                this.encodeBottom(this.minValueAsBytes);
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO) {
                    NumericUtils.nextUp(this.minValueAsBytes);
                }
            }
        }

        private void encodeTop() {
            if (!NumericComparator.this.reverse) {
                this.encodeTop(this.minValueAsBytes);
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull) {
                    NumericUtils.nextUp(this.minValueAsBytes);
                }
            } else {
                this.encodeTop(this.maxValueAsBytes);
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull) {
                    NumericUtils.nextDown(this.maxValueAsBytes);
                }
            }
        }

        private boolean isMissingValueCompetitive() {
            if (NumericComparator.this.queueFull) {
                int result = this.compareMissingValueWithBottomValue();
                return NumericComparator.this.reverse ? (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result > 0 : result >= 0) : (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result < 0 : result <= 0);
            }
            if (NumericComparator.this.topValueSet) {
                int result = this.compareMissingValueWithTopValue();
                return NumericComparator.this.reverse ? result <= 0 : result >= 0;
            }
            return true;
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            if (!this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(){
                private int docID;
                {
                    this.docID = NumericLeafComparator.this.competitiveIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                @Override
                public int docID() {
                    return this.docID;
                }

                @Override
                public long cost() {
                    return NumericLeafComparator.this.competitiveIterator.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    this.docID = NumericLeafComparator.this.competitiveIterator.advance(target);
                    return this.docID;
                }
            };
        }

        protected abstract int compareMissingValueWithTopValue();

        protected abstract int compareMissingValueWithBottomValue();

        protected abstract void encodeBottom(byte[] var1);

        protected abstract void encodeTop(byte[] var1);
    }
}

