/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.AutomatonQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.AutomatonProvider;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.RegExp;

public class RegexpQuery
extends AutomatonQuery {
    public static final AutomatonProvider DEFAULT_PROVIDER = name -> null;

    public RegexpQuery(Term term) {
        this(term, 255);
    }

    public RegexpQuery(Term term, int flags) {
        this(term, flags, DEFAULT_PROVIDER, 10000);
    }

    public RegexpQuery(Term term, int flags, int determinizeWorkLimit) {
        this(term, flags, DEFAULT_PROVIDER, determinizeWorkLimit);
    }

    public RegexpQuery(Term term, int syntax_flags, int match_flags, int determinizeWorkLimit) {
        this(term, syntax_flags, match_flags, DEFAULT_PROVIDER, determinizeWorkLimit, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public RegexpQuery(Term term, int syntax_flags, AutomatonProvider provider, int determinizeWorkLimit) {
        this(term, syntax_flags, 0, provider, determinizeWorkLimit, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public RegexpQuery(Term term, int syntax_flags, int match_flags, AutomatonProvider provider, int determinizeWorkLimit, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(term, new RegExp(term.text(), syntax_flags, match_flags).toAutomaton(provider, determinizeWorkLimit), determinizeWorkLimit, false, rewriteMethod);
    }

    public Term getRegexp() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append('/');
        buffer.append(this.term.text());
        buffer.append('/');
        return buffer.toString();
    }
}

