/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.VectorSimilarityValuesSource;

class FloatVectorSimilarityValuesSource
extends VectorSimilarityValuesSource {
    private final float[] queryVector;

    public FloatVectorSimilarityValuesSource(float[] vector, String fieldName) {
        super(fieldName);
        this.queryVector = vector;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(this.fieldName);
        final VectorSimilarityFunction function = ctx.reader().getFieldInfos().fieldInfo(this.fieldName).getVectorSimilarityFunction();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return function.compare(FloatVectorSimilarityValuesSource.this.queryVector, vectorValues.vectorValue());
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= vectorValues.docID() && (vectorValues.docID() == doc || vectorValues.advance(doc) == doc);
            }
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.queryVector));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FloatVectorSimilarityValuesSource other = (FloatVectorSimilarityValuesSource)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.queryVector, other.queryVector);
    }

    @Override
    public String toString() {
        return "FloatVectorSimilarityValuesSource(fieldName=" + this.fieldName + " queryVector=" + Arrays.toString(this.queryVector) + ")";
    }
}

