/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.valuesource.VectorSimilarityFunction;

public class ByteVectorSimilarityFunction
extends VectorSimilarityFunction {
    public ByteVectorSimilarityFunction(org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction similarityFunction, ValueSource vector1, ValueSource vector2) {
        super(similarityFunction, vector1, vector2);
    }

    @Override
    protected float func(int doc, FunctionValues f1, FunctionValues f2) throws IOException {
        byte[] v1 = f1.byteVectorVal(doc);
        byte[] v2 = f2.byteVectorVal(doc);
        if (v1 == null || v2 == null) {
            return 0.0f;
        }
        assert (v1.length == v2.length) : "Vectors must have the same length";
        return this.similarityFunction.compare(v1, v2);
    }
}

