/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldExistsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

final class SortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.lowerValue, this.upperValue);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesRangeQuery.this.field);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesRangeQuery.this.field) == null) {
                    return null;
                }
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesRangeQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= SortedNumericDocValuesRangeQuery.this.lowerValue && value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                } : new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < SortedNumericDocValuesRangeQuery.this.lowerValue) continue;
                            return value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }
        };
    }
}

