/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99.RandomAccessQuantizedByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ScalarQuantizedVectorSimilarity;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ScalarQuantizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.VectorUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomVectorScorer;

final class ScalarQuantizedRandomVectorScorer
extends RandomVectorScorer.AbstractRandomVectorScorer<byte[]> {
    private final byte[] quantizedQuery;
    private final float queryOffset;
    private final RandomAccessQuantizedByteVectorValues values;
    private final ScalarQuantizedVectorSimilarity similarity;

    private static float quantizeQuery(float[] query, byte[] quantizedQuery, VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer) {
        float[] processedQuery = query;
        if (similarityFunction.equals((Object)VectorSimilarityFunction.COSINE)) {
            float[] queryCopy = ArrayUtil.copyOfSubArray(query, 0, query.length);
            VectorUtil.l2normalize(queryCopy);
            processedQuery = queryCopy;
        }
        return scalarQuantizer.quantize(processedQuery, quantizedQuery, similarityFunction);
    }

    ScalarQuantizedRandomVectorScorer(ScalarQuantizedVectorSimilarity similarityFunction, RandomAccessQuantizedByteVectorValues values, byte[] query, float queryOffset) {
        super(values);
        this.quantizedQuery = query;
        this.queryOffset = queryOffset;
        this.similarity = similarityFunction;
        this.values = values;
    }

    ScalarQuantizedRandomVectorScorer(VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer, RandomAccessQuantizedByteVectorValues values, float[] query) {
        super(values);
        byte[] quantizedQuery = new byte[query.length];
        float correction = ScalarQuantizedRandomVectorScorer.quantizeQuery(query, quantizedQuery, similarityFunction, scalarQuantizer);
        this.quantizedQuery = quantizedQuery;
        this.queryOffset = correction;
        this.similarity = ScalarQuantizedVectorSimilarity.fromVectorSimilarity(similarityFunction, scalarQuantizer.getConstantMultiplier());
        this.values = values;
    }

    @Override
    public float score(int node) throws IOException {
        byte[] storedVectorValue = (byte[])this.values.vectorValue(node);
        float storedVectorCorrection = this.values.getScoreCorrectionConstant();
        return this.similarity.score(this.quantizedQuery, this.queryOffset, storedVectorValue, storedVectorCorrection);
    }
}

