/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FlatVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99.QuantizedByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99.QuantizedVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene99.ScalarQuantizedRandomVectorScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ScalarQuantizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomVectorScorer;

public final class Lucene99ScalarQuantizedVectorsReader
extends FlatVectorsReader
implements QuantizedVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99ScalarQuantizedVectorsReader.class);
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput quantizedVectorData;
    private final FlatVectorsReader rawVectorsReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene99ScalarQuantizedVectorsReader(SegmentReadState state, FlatVectorsReader rawVectorsReader) throws IOException {
        this.rawVectorsReader = rawVectorsReader;
        int versionMeta = -1;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemq");
        boolean success = false;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99ScalarQuantizedVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter(meta, priorE);
                }
                this.quantizedVectorData = Lucene99ScalarQuantizedVectorsReader.openDataInput(state, versionMeta, "veq", "Lucene99ScalarQuantizedVectorsFormatData");
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta);
            Lucene99ScalarQuantizedVectorsReader.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    static void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long quantizedVectorBytes = dimension + 4;
        long numQuantizedVectorBytes = Math.multiplyExact(quantizedVectorBytes, fieldEntry.size);
        if (numQuantizedVectorBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Quantized vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size + " * (dim=" + dimension + " + 4) = " + numQuantizedVectorBytes);
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.rawVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.quantizedVectorData);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.rawVectorsReader.getFloatVectorValues(field);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.rawVectorsReader.getByteVectorValues(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        if (fieldEntry.scalarQuantizer == null) {
            return this.rawVectorsReader.getRandomVectorScorer(field, target);
        }
        OffHeapQuantizedByteVectorValues vectorValues = OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        return new ScalarQuantizedRandomVectorScorer(fieldEntry.similarityFunction, fieldEntry.scalarQuantizer, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.rawVectorsReader.getRandomVectorScorer(field, target);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.quantizedVectorData, this.rawVectorsReader);
    }

    @Override
    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        return size += this.rawVectorsReader.ramBytesUsed();
    }

    private FieldEntry readField(IndexInput input) throws IOException {
        VectorEncoding vectorEncoding = this.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        return new FieldEntry(input, vectorEncoding, similarityFunction);
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    @Override
    public QuantizedByteVectorValues getQuantizedVectorValues(String fieldName) throws IOException {
        FieldEntry fieldEntry = this.fields.get(fieldName);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        return OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
    }

    @Override
    public ScalarQuantizer getQuantizationState(String fieldName) {
        FieldEntry fieldEntry = this.fields.get(fieldName);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        return fieldEntry.scalarQuantizer;
    }

    private static class FieldEntry
    implements Accountable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class);
        final VectorSimilarityFunction similarityFunction;
        final VectorEncoding vectorEncoding;
        final int dimension;
        final long vectorDataOffset;
        final long vectorDataLength;
        final ScalarQuantizer scalarQuantizer;
        final int size;
        final OrdToDocDISIReaderConfiguration ordToDoc;

        FieldEntry(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.vectorDataOffset = input.readVLong();
            this.vectorDataLength = input.readVLong();
            this.dimension = input.readVInt();
            this.size = input.readInt();
            if (this.size > 0) {
                float confidenceInterval = Float.intBitsToFloat(input.readInt());
                float minQuantile = Float.intBitsToFloat(input.readInt());
                float maxQuantile = Float.intBitsToFloat(input.readInt());
                this.scalarQuantizer = new ScalarQuantizer(minQuantile, maxQuantile, confidenceInterval);
            } else {
                this.scalarQuantizer = null;
            }
            this.ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta(input, this.size);
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf(this.ordToDoc);
        }
    }
}

