/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree.FieldReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree.IntersectTermsEnumFrame;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree.SegmentTermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BaseTermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ImpactsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.StringHelper;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.RunAutomaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Transition;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.FST;

final class IntersectTermsEnum
extends BaseTermsEnum {
    final IndexInput in;
    IntersectTermsEnumFrame[] stack;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[5];
    final RunAutomaton runAutomaton;
    final Automaton automaton;
    final BytesRef commonSuffix;
    private IntersectTermsEnumFrame currentFrame;
    private Transition currentTransition;
    private final BytesRef term = new BytesRef();
    private final FST.BytesReader fstReader;
    final FieldReader fr;
    private BytesRef savedStartTerm;
    private final SegmentTermsEnum.OutputAccumulator outputAccumulator = new SegmentTermsEnum.OutputAccumulator();

    public IntersectTermsEnum(FieldReader fr, Automaton automaton, RunAutomaton runAutomaton, BytesRef commonSuffix, BytesRef startTerm) throws IOException {
        this.fr = fr;
        assert (automaton != null);
        assert (runAutomaton != null);
        this.runAutomaton = runAutomaton;
        this.automaton = automaton;
        this.commonSuffix = commonSuffix;
        this.in = fr.parent.termsIn.clone();
        this.stack = new IntersectTermsEnumFrame[5];
        for (int idx = 0; idx < this.stack.length; ++idx) {
            this.stack[idx] = new IntersectTermsEnumFrame(this, idx);
        }
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.fstReader = fr.index.getBytesReader();
        FST.Arc<BytesRef> arc = fr.index.getFirstArc(this.arcs[0]);
        assert (arc.isFinal());
        IntersectTermsEnumFrame f = this.stack[0];
        f.fp = f.fpOrig = fr.rootBlockFP;
        f.prefix = 0;
        f.setState(0);
        f.arc = arc;
        f.load(fr.rootCode);
        assert (this.setSavedStartTerm(startTerm));
        this.currentFrame = f;
        this.outputAccumulator.push(this.currentFrame.arc.output());
        if (startTerm != null) {
            this.seekToStartTerm(startTerm);
        }
        this.currentTransition = this.currentFrame.transition;
    }

    private boolean setSavedStartTerm(BytesRef startTerm) {
        this.savedStartTerm = startTerm == null ? null : BytesRef.deepCopyOf(startTerm);
        return true;
    }

    @Override
    public TermState termState() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.clone();
    }

    private IntersectTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            IntersectTermsEnumFrame[] next = new IntersectTermsEnumFrame[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new IntersectTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next.length; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        return this.arcs[ord];
    }

    private IntersectTermsEnumFrame pushFrame(int state) throws IOException {
        assert (this.currentFrame != null);
        IntersectTermsEnumFrame f = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord);
        f.fp = f.fpOrig = this.currentFrame.lastSubFP;
        f.prefix = this.currentFrame.prefix + this.currentFrame.suffix;
        f.setState(state);
        FST.Arc<BytesRef> arc = this.currentFrame.arc;
        assert (this.currentFrame.suffix > 0);
        int initOutputCount = this.outputAccumulator.outputCount();
        for (int idx = this.currentFrame.prefix; idx < f.prefix; ++idx) {
            int target = this.term.bytes[idx] & 0xFF;
            arc = this.fr.index.findTargetArc(target, arc, this.getArc(1 + idx), this.fstReader);
            assert (arc != null);
            this.outputAccumulator.push(arc.output());
        }
        f.arc = arc;
        f.outputNum = this.outputAccumulator.outputCount() - initOutputCount;
        assert (arc.isFinal());
        this.outputAccumulator.push(arc.nextFinalOutput());
        f.load(this.outputAccumulator);
        this.outputAccumulator.pop(arc.nextFinalOutput());
        return f;
    }

    @Override
    public BytesRef term() {
        return this.term;
    }

    @Override
    public int docFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.termState, reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.impacts(this.fr.fieldInfo, this.currentFrame.termState, flags);
    }

    private int getState() {
        int state = this.currentFrame.state;
        for (int idx = 0; idx < this.currentFrame.suffix; ++idx) {
            state = this.runAutomaton.step(state, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + idx] & 0xFF);
            assert (state != -1);
        }
        return state;
    }

    private void seekToStartTerm(BytesRef target) throws IOException {
        assert (this.currentFrame.ord == 0);
        if (this.term.length < target.length) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, target.length);
        }
        FST.Arc<BytesRef> arc = this.arcs[0];
        assert (arc == this.currentFrame.arc);
        for (int idx = 0; idx <= target.length; ++idx) {
            block8: {
                int cmp;
                int saveTermBlockOrd;
                long saveLastSubFP;
                int saveSuffix;
                int saveStartBytePos;
                int saveLengthPos;
                int savePos;
                int savNextEnt;
                block9: {
                    while (true) {
                        savNextEnt = this.currentFrame.nextEnt;
                        savePos = this.currentFrame.suffixesReader.getPosition();
                        saveLengthPos = this.currentFrame.suffixLengthsReader.getPosition();
                        saveStartBytePos = this.currentFrame.startBytePos;
                        saveSuffix = this.currentFrame.suffix;
                        saveLastSubFP = this.currentFrame.lastSubFP;
                        saveTermBlockOrd = this.currentFrame.termState.termBlockOrd;
                        boolean isSubBlock = this.currentFrame.next();
                        this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                        if (this.term.bytes.length < this.term.length) {
                            this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
                        }
                        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                        if (isSubBlock && StringHelper.startsWith(target, this.term)) break block8;
                        cmp = this.term.compareTo(target);
                        if (cmp >= 0) break block9;
                        if (this.currentFrame.nextEnt != this.currentFrame.entCount) continue;
                        if (this.currentFrame.isLastInFloor) break;
                        this.currentFrame.loadNextFloorBlock();
                    }
                    return;
                }
                if (cmp == 0) {
                    return;
                }
                this.currentFrame.nextEnt = savNextEnt;
                this.currentFrame.lastSubFP = saveLastSubFP;
                this.currentFrame.startBytePos = saveStartBytePos;
                this.currentFrame.suffix = saveSuffix;
                this.currentFrame.suffixesReader.setPosition(savePos);
                this.currentFrame.suffixLengthsReader.setPosition(saveLengthPos);
                this.currentFrame.termState.termBlockOrd = saveTermBlockOrd;
                System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                return;
            }
            this.currentFrame = this.pushFrame(this.getState());
        }
        assert (false);
    }

    private boolean popPushNext() throws IOException {
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                throw NoMoreTermsException.INSTANCE;
            }
            long lastFP = this.currentFrame.fpOrig;
            this.outputAccumulator.pop(this.currentFrame.outputNum);
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            this.currentTransition = this.currentFrame.transition;
            assert (this.currentFrame.lastSubFP == lastFP);
        }
        return this.currentFrame.next();
    }

    @Override
    public BytesRef next() throws IOException {
        try {
            return this._next();
        }
        catch (NoMoreTermsException eoi) {
            this.currentFrame = null;
            return null;
        }
    }

    private BytesRef _next() throws IOException {
        boolean isSubBlock = this.popPushNext();
        block0: while (true) {
            int state;
            int lastState;
            assert (this.currentFrame.transition == this.currentTransition);
            if (this.currentFrame.suffix != 0) {
                int minTrans;
                byte[] suffixBytes = this.currentFrame.suffixBytes;
                int label = suffixBytes[this.currentFrame.startBytePos] & 0xFF;
                if (label < this.currentTransition.min) {
                    minTrans = this.currentTransition.min;
                    while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                        isSubBlock = this.currentFrame.next();
                        if ((suffixBytes[this.currentFrame.startBytePos] & 0xFF) < minTrans) continue;
                        continue block0;
                    }
                    isSubBlock = this.popPushNext();
                    continue;
                }
                while (label > this.currentTransition.max) {
                    if (this.currentFrame.transitionIndex >= this.currentFrame.transitionCount - 1) {
                        if (this.currentFrame.ord == 0) {
                            this.currentFrame = null;
                            return null;
                        }
                        this.outputAccumulator.pop(this.currentFrame.outputNum);
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        this.currentTransition = this.currentFrame.transition;
                        isSubBlock = this.popPushNext();
                        continue block0;
                    }
                    ++this.currentFrame.transitionIndex;
                    this.automaton.getNextTransition(this.currentTransition);
                    if (label >= this.currentTransition.min) continue;
                    minTrans = this.currentTransition.min;
                    while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                        isSubBlock = this.currentFrame.next();
                        if ((suffixBytes[this.currentFrame.startBytePos] & 0xFF) < minTrans) continue;
                        continue block0;
                    }
                    isSubBlock = this.popPushNext();
                    continue block0;
                }
                if (this.commonSuffix != null && !isSubBlock) {
                    int suffixBytesPos;
                    int termLen = this.currentFrame.prefix + this.currentFrame.suffix;
                    if (termLen < this.commonSuffix.length) {
                        isSubBlock = this.popPushNext();
                        continue;
                    }
                    byte[] commonSuffixBytes = this.commonSuffix.bytes;
                    int lenInPrefix = this.commonSuffix.length - this.currentFrame.suffix;
                    assert (this.commonSuffix.offset == 0);
                    int commonSuffixBytesPos = 0;
                    if (lenInPrefix > 0) {
                        byte[] termBytes = this.term.bytes;
                        int termBytesPos = this.currentFrame.prefix - lenInPrefix;
                        assert (termBytesPos >= 0);
                        int termBytesPosEnd = this.currentFrame.prefix;
                        while (termBytesPos < termBytesPosEnd) {
                            if (termBytes[termBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                            isSubBlock = this.popPushNext();
                            continue block0;
                        }
                        suffixBytesPos = this.currentFrame.startBytePos;
                    } else {
                        suffixBytesPos = this.currentFrame.startBytePos + this.currentFrame.suffix - this.commonSuffix.length;
                    }
                    int commonSuffixBytesPosEnd = this.commonSuffix.length;
                    while (commonSuffixBytesPos < commonSuffixBytesPosEnd) {
                        if (suffixBytes[suffixBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                        isSubBlock = this.popPushNext();
                        continue block0;
                    }
                }
                lastState = this.currentFrame.state;
                state = this.currentTransition.dest;
                int end = this.currentFrame.startBytePos + this.currentFrame.suffix;
                for (int idx = this.currentFrame.startBytePos + 1; idx < end; ++idx) {
                    lastState = state;
                    if ((state = this.runAutomaton.step(state, suffixBytes[idx] & 0xFF)) != -1) continue;
                    isSubBlock = this.popPushNext();
                    continue block0;
                }
            } else {
                state = this.currentFrame.state;
                lastState = this.currentFrame.lastState;
            }
            if (isSubBlock) {
                this.copyTerm();
                this.currentFrame = this.pushFrame(state);
                this.currentTransition = this.currentFrame.transition;
                this.currentFrame.lastState = lastState;
            } else if (this.runAutomaton.isAccept(state)) {
                this.copyTerm();
                assert (this.savedStartTerm == null || this.term.compareTo(this.savedStartTerm) > 0) : "saveStartTerm=" + this.savedStartTerm.utf8ToString() + " term=" + this.term.utf8ToString();
                return this.term;
            }
            isSubBlock = this.popPushNext();
        }
    }

    static String brToString(BytesRef b) {
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    private void copyTerm() {
        int len = this.currentFrame.prefix + this.currentFrame.suffix;
        if (this.term.bytes.length < len) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, len);
        }
        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
        this.term.length = len;
    }

    @Override
    public boolean seekExact(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    private static final class NoMoreTermsException
    extends RuntimeException {
        public static final NoMoreTermsException INSTANCE = new NoMoreTermsException();

        private NoMoreTermsException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

