/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FieldsProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.NormsProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Fields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MappedMultiFields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ReaderSlice;

public abstract class FieldsConsumer
implements Closeable {
    protected FieldsConsumer() {
    }

    public abstract void write(Fields var1, NormsProducer var2) throws IOException;

    public void merge(MergeState mergeState, NormsProducer norms) throws IOException {
        ArrayList<FieldsProducer> fields = new ArrayList<FieldsProducer>();
        ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
        int docBase = 0;
        for (int readerIndex = 0; readerIndex < mergeState.fieldsProducers.length; ++readerIndex) {
            FieldsProducer f = mergeState.fieldsProducers[readerIndex];
            int maxDoc = mergeState.maxDocs[readerIndex];
            if (f != null) {
                f.checkIntegrity();
                slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
                fields.add(f);
            }
            docBase += maxDoc;
        }
        MappedMultiFields mergedFields = new MappedMultiFields(mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
        this.write(mergedFields, norms);
    }

    @Override
    public abstract void close() throws IOException;
}

