/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.Telemetry;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.TelemetrySettings;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.DefaultTracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.ThreadContextBasedTracerContextStorage;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.TracingTelemetry;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.WrappedTracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.noop.NoopTracer;

@InternalApi
public class TracerFactory
implements Closeable {
    private static final Logger logger = LogManager.getLogger(TracerFactory.class);
    private final TelemetrySettings telemetrySettings;
    private final Tracer tracer;

    public TracerFactory(TelemetrySettings telemetrySettings, Optional<Telemetry> telemetry, ThreadContext threadContext) {
        this.telemetrySettings = telemetrySettings;
        this.tracer = this.tracer(telemetry, threadContext);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public void close() {
        try {
            this.tracer.close();
        }
        catch (IOException e) {
            logger.warn("Error closing tracer", (Throwable)e);
        }
    }

    private Tracer tracer(Optional<Telemetry> telemetry, ThreadContext threadContext) {
        return telemetry.map(Telemetry::getTracingTelemetry).map(tracingTelemetry -> this.createDefaultTracer((TracingTelemetry)tracingTelemetry, threadContext)).map(defaultTracer -> this.createWrappedTracer((Tracer)defaultTracer)).orElse(NoopTracer.INSTANCE);
    }

    private Tracer createDefaultTracer(TracingTelemetry tracingTelemetry, ThreadContext threadContext) {
        ThreadContextBasedTracerContextStorage tracerContextStorage = new ThreadContextBasedTracerContextStorage(threadContext, tracingTelemetry);
        return new DefaultTracer(tracingTelemetry, tracerContextStorage);
    }

    private Tracer createWrappedTracer(Tracer defaultTracer) {
        return new WrappedTracer(this.telemetrySettings, defaultTracer);
    }
}

