/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.http.HttpRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanCreationContext;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.attributes.Attributes;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;

@InternalApi
public final class SpanBuilder {
    private static final List<String> HEADERS_TO_BE_ADDED_AS_ATTRIBUTES = Arrays.asList("trace");
    private static final String SEPARATOR = " ";

    private SpanBuilder() {
    }

    public static SpanCreationContext from(HttpRequest request) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(request)).attributes(SpanBuilder.buildSpanAttributes(request));
    }

    public static SpanCreationContext from(RestRequest request) {
        return SpanCreationContext.client().name(SpanBuilder.createSpanName(request)).attributes(SpanBuilder.buildSpanAttributes(request));
    }

    public static SpanCreationContext from(String action, Transport.Connection connection) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(action, connection)).attributes(SpanBuilder.buildSpanAttributes(action, connection));
    }

    private static String createSpanName(HttpRequest httpRequest) {
        return httpRequest.method().name() + SEPARATOR + httpRequest.uri();
    }

    private static Attributes buildSpanAttributes(HttpRequest httpRequest) {
        Attributes attributes = Attributes.create().addAttribute("http.uri", httpRequest.uri()).addAttribute("http.method", httpRequest.method().name()).addAttribute("http.version", httpRequest.protocolVersion().name());
        SpanBuilder.populateHeader(httpRequest, attributes);
        return attributes;
    }

    private static void populateHeader(HttpRequest httpRequest, Attributes attributes) {
        HEADERS_TO_BE_ADDED_AS_ATTRIBUTES.forEach(x -> {
            if (httpRequest.getHeaders() != null && httpRequest.getHeaders().get(x) != null && !httpRequest.getHeaders().get(x).isEmpty()) {
                attributes.addAttribute((String)x, Strings.collectionToCommaDelimitedString((Iterable)httpRequest.getHeaders().get(x)));
            }
        });
    }

    private static String createSpanName(RestRequest restRequest) {
        Object spanName = "rest_request";
        if (restRequest != null) {
            try {
                String methodName = restRequest.method().name();
                String path = restRequest.path();
                spanName = methodName + SEPARATOR + path;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return spanName;
    }

    private static Attributes buildSpanAttributes(RestRequest restRequest) {
        if (restRequest != null) {
            return Attributes.create().addAttribute("rest.request_id", restRequest.getRequestId()).addAttribute("rest.raw_path", restRequest.rawPath());
        }
        return Attributes.EMPTY;
    }

    private static String createSpanName(String action, Transport.Connection connection) {
        return action + SEPARATOR + (connection.getNode() != null ? connection.getNode().getHostAddress() : null);
    }

    private static Attributes buildSpanAttributes(String action, Transport.Connection connection) {
        Attributes attributes = Attributes.create().addAttribute("action", action);
        if (connection != null && connection.getNode() != null) {
            attributes.addAttribute("target_host", connection.getNode().getHostAddress());
        }
        return attributes;
    }

    public static SpanCreationContext from(String action, TcpChannel tcpChannel) {
        return SpanCreationContext.server().name(SpanBuilder.createSpanName(action, tcpChannel)).attributes(SpanBuilder.buildSpanAttributes(action, tcpChannel));
    }

    private static String createSpanName(String action, TcpChannel tcpChannel) {
        return action + SEPARATOR + (tcpChannel.getRemoteAddress() != null ? tcpChannel.getRemoteAddress().getHostString() : tcpChannel.getLocalAddress().getHostString());
    }

    private static Attributes buildSpanAttributes(String action, TcpChannel tcpChannel) {
        Attributes attributes = Attributes.create().addAttribute("action", action);
        attributes.addAttribute("host", tcpChannel.getLocalAddress().getHostString());
        return attributes;
    }
}

