/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.NotifyOnceListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteable;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.TaskId;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ResourceStats;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ResourceStatsType;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ResourceUsageInfo;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ResourceUsageMetric;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.TaskResourceStats;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.TaskThreadUsage;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ThreadResourceInfo;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.CancellableTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskInfo;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskResult;

public class Task {
    private static final Logger logger = LogManager.getLogger(Task.class);
    public static final String X_OPAQUE_ID = "X-Opaque-Id";
    private static final String TOTAL = "total";
    private static final String AVERAGE = "average";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private final long id;
    private final String type;
    private final String action;
    private final String description;
    private final TaskId parentTask;
    private final Map<String, String> headers;
    private final Map<Long, List<ThreadResourceInfo>> resourceStats;
    private final List<NotifyOnceListener<Task>> resourceTrackingCompletionListeners;
    private final AtomicInteger numActiveResourceTrackingThreads = new AtomicInteger(1);
    private final long startTime;
    private final long startTimeNanos;

    public Task(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        this(id, type, action, description, parentTask, System.currentTimeMillis(), System.nanoTime(), headers, new ConcurrentHashMap<Long, List<ThreadResourceInfo>>(), new ArrayList<NotifyOnceListener<Task>>());
    }

    public Task(long id, String type, String action, String description, TaskId parentTask, long startTime, long startTimeNanos, Map<String, String> headers, ConcurrentHashMap<Long, List<ThreadResourceInfo>> resourceStats, List<NotifyOnceListener<Task>> resourceTrackingCompletionListeners) {
        this.id = id;
        this.type = type;
        this.action = action;
        this.description = description;
        this.parentTask = parentTask;
        this.startTime = startTime;
        this.startTimeNanos = startTimeNanos;
        this.headers = headers;
        this.resourceStats = resourceStats;
        this.resourceTrackingCompletionListeners = resourceTrackingCompletionListeners;
    }

    public final TaskInfo taskInfo(String localNodeId, boolean detailed) {
        return this.taskInfo(localNodeId, detailed, !detailed);
    }

    private TaskInfo taskInfo(String localNodeId, boolean detailed, boolean excludeStats) {
        String description = null;
        Status status = null;
        TaskResourceStats resourceStats = null;
        if (detailed) {
            description = this.getDescription();
            status = this.getStatus();
        }
        if (!excludeStats) {
            resourceStats = new TaskResourceStats((Map<String, TaskResourceUsage>)new HashMap<String, TaskResourceUsage>(){
                {
                    this.put(Task.TOTAL, Task.this.getTotalResourceStats());
                    this.put(Task.AVERAGE, Task.this.getAverageResourceStats());
                    this.put(Task.MIN, Task.this.getMinResourceStats());
                    this.put(Task.MAX, Task.this.getMaxResourceStats());
                }
            }, this.getThreadUsage());
        }
        return this.taskInfo(localNodeId, description, status, resourceStats);
    }

    protected final TaskInfo taskInfo(String localNodeId, String description, Status status) {
        return this.taskInfo(localNodeId, description, status, null);
    }

    protected final TaskInfo taskInfo(String localNodeId, String description, Status status, TaskResourceStats resourceStats) {
        boolean cancelled = this instanceof CancellableTask && ((CancellableTask)this).isCancelled();
        Long cancellationStartTime = null;
        if (cancelled) {
            cancellationStartTime = ((CancellableTask)this).getCancellationStartTime();
        }
        return new TaskInfo(new TaskId(localNodeId, this.getId()), this.getType(), this.getAction(), description, status, this.startTime, System.nanoTime() - this.startTimeNanos, this instanceof CancellableTask, cancelled, this.parentTask, this.headers, resourceStats, cancellationStartTime);
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public TaskId getParentTaskId() {
        return this.parentTask;
    }

    public Status getStatus() {
        return null;
    }

    public Map<Long, List<ThreadResourceInfo>> getResourceStats() {
        return Collections.unmodifiableMap(this.resourceStats);
    }

    public TaskResourceUsage getTotalResourceStats() {
        return new TaskResourceUsage(this.getTotalResourceUtilization(ResourceStats.CPU), this.getTotalResourceUtilization(ResourceStats.MEMORY));
    }

    public TaskResourceUsage getAverageResourceStats() {
        return new TaskResourceUsage(this.getAverageResourceUtilization(ResourceStats.CPU), this.getAverageResourceUtilization(ResourceStats.MEMORY));
    }

    public TaskResourceUsage getMinResourceStats() {
        return new TaskResourceUsage(this.getMinResourceUtilization(ResourceStats.CPU), this.getMinResourceUtilization(ResourceStats.MEMORY));
    }

    public TaskResourceUsage getMaxResourceStats() {
        return new TaskResourceUsage(this.getMaxResourceUtilization(ResourceStats.CPU), this.getMaxResourceUtilization(ResourceStats.MEMORY));
    }

    public long getTotalResourceUtilization(ResourceStats stats) {
        long totalResourceConsumption = 0L;
        for (List<ThreadResourceInfo> threadResourceInfosList : this.resourceStats.values()) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfosList) {
                ResourceUsageInfo.ResourceStatsInfo statsInfo = threadResourceInfo.getResourceUsageInfo().getStatsInfo().get((Object)stats);
                if (threadResourceInfo.getStatsType().isOnlyForAnalysis() || statsInfo == null) continue;
                totalResourceConsumption += statsInfo.getTotalValue();
            }
        }
        return totalResourceConsumption;
    }

    private long getAverageResourceUtilization(ResourceStats stats) {
        long totalResourceConsumption = 0L;
        int threadResourceInfoCount = 0;
        for (List<ThreadResourceInfo> threadResourceInfosList : this.resourceStats.values()) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfosList) {
                ResourceUsageInfo.ResourceStatsInfo statsInfo = threadResourceInfo.getResourceUsageInfo().getStatsInfo().get((Object)stats);
                if (threadResourceInfo.getStatsType().isOnlyForAnalysis() || statsInfo == null) continue;
                totalResourceConsumption += statsInfo.getTotalValue();
                ++threadResourceInfoCount;
            }
        }
        return threadResourceInfoCount > 0 ? totalResourceConsumption / (long)threadResourceInfoCount : 0L;
    }

    private long getMinResourceUtilization(ResourceStats stats) {
        if (this.resourceStats.size() == 0) {
            return 0L;
        }
        long minResourceConsumption = Long.MAX_VALUE;
        for (List<ThreadResourceInfo> threadResourceInfosList : this.resourceStats.values()) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfosList) {
                ResourceUsageInfo.ResourceStatsInfo statsInfo = threadResourceInfo.getResourceUsageInfo().getStatsInfo().get((Object)stats);
                if (threadResourceInfo.getStatsType().isOnlyForAnalysis() || statsInfo == null) continue;
                minResourceConsumption = Math.min(minResourceConsumption, statsInfo.getTotalValue());
            }
        }
        return minResourceConsumption;
    }

    private long getMaxResourceUtilization(ResourceStats stats) {
        long maxResourceConsumption = 0L;
        for (List<ThreadResourceInfo> threadResourceInfosList : this.resourceStats.values()) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfosList) {
                ResourceUsageInfo.ResourceStatsInfo statsInfo = threadResourceInfo.getResourceUsageInfo().getStatsInfo().get((Object)stats);
                if (threadResourceInfo.getStatsType().isOnlyForAnalysis() || statsInfo == null) continue;
                maxResourceConsumption = Math.max(maxResourceConsumption, statsInfo.getTotalValue());
            }
        }
        return maxResourceConsumption;
    }

    public TaskThreadUsage getThreadUsage() {
        int numThreadExecutions = 0;
        int activeThreads = 0;
        for (List<ThreadResourceInfo> threadResourceInfosList : this.resourceStats.values()) {
            numThreadExecutions += threadResourceInfosList.size();
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfosList) {
                if (!threadResourceInfo.isActive()) continue;
                ++activeThreads;
            }
        }
        return new TaskThreadUsage(numThreadExecutions, activeThreads);
    }

    public void startThreadResourceTracking(long threadId, ResourceStatsType statsType, ResourceUsageMetric ... resourceUsageMetrics) {
        List threadResourceInfoList = this.resourceStats.computeIfAbsent(threadId, k -> new ArrayList());
        for (ThreadResourceInfo threadResourceInfo : threadResourceInfoList) {
            if (threadResourceInfo.getStatsType() != statsType || !threadResourceInfo.isActive()) continue;
            throw new IllegalStateException("unexpected active thread resource entry present [" + threadId + "]:[" + threadResourceInfo + "]");
        }
        threadResourceInfoList.add(new ThreadResourceInfo(threadId, statsType, resourceUsageMetrics));
        this.incrementResourceTrackingThreads();
    }

    public void updateThreadResourceStats(long threadId, ResourceStatsType statsType, ResourceUsageMetric ... resourceUsageMetrics) {
        List<ThreadResourceInfo> threadResourceInfoList = this.resourceStats.get(threadId);
        if (threadResourceInfoList != null) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfoList) {
                if (threadResourceInfo.getStatsType() != statsType || !threadResourceInfo.isActive()) continue;
                threadResourceInfo.recordResourceUsageMetrics(resourceUsageMetrics);
                return;
            }
        }
        throw new IllegalStateException("cannot update if active thread resource entry is not present");
    }

    public void stopThreadResourceTracking(long threadId, ResourceStatsType statsType, ResourceUsageMetric ... resourceUsageMetrics) {
        List<ThreadResourceInfo> threadResourceInfoList = this.resourceStats.get(threadId);
        if (threadResourceInfoList != null) {
            for (ThreadResourceInfo threadResourceInfo : threadResourceInfoList) {
                if (threadResourceInfo.getStatsType() != statsType || !threadResourceInfo.isActive()) continue;
                threadResourceInfo.setActive(false);
                threadResourceInfo.recordResourceUsageMetrics(resourceUsageMetrics);
                this.decrementResourceTrackingThreads();
                return;
            }
        }
        throw new IllegalStateException("cannot update final values if active thread resource entry is not present");
    }

    public boolean supportsResourceTracking() {
        return false;
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public TaskResult result(String nodeId, Exception error) throws IOException {
        return new TaskResult(this.taskInfo(nodeId, true, true), error);
    }

    public TaskResult result(String nodeId, ActionResponse response) throws IOException {
        if (response instanceof ToXContent) {
            return new TaskResult(this.taskInfo(nodeId, true, true), (ToXContent)((Object)response));
        }
        throw new IllegalStateException("response has to implement ToXContent to be able to store the results");
    }

    public boolean addResourceTrackingCompletionListener(NotifyOnceListener<Task> listener) {
        if (this.numActiveResourceTrackingThreads.get() > 0) {
            this.resourceTrackingCompletionListeners.add(listener);
            return true;
        }
        return false;
    }

    public int incrementResourceTrackingThreads() {
        return this.numActiveResourceTrackingThreads.incrementAndGet();
    }

    public int decrementResourceTrackingThreads() {
        int count = this.numActiveResourceTrackingThreads.decrementAndGet();
        if (count == 0) {
            ArrayList listenerExceptions = new ArrayList();
            this.resourceTrackingCompletionListeners.forEach(listener -> {
                try {
                    listener.onResponse(this);
                }
                catch (Exception e1) {
                    try {
                        listener.onFailure(e1);
                    }
                    catch (Exception e2) {
                        listenerExceptions.add(e2);
                    }
                }
            });
            ExceptionsHelper.maybeThrowRuntimeAndSuppress(listenerExceptions);
        }
        return count;
    }

    public static interface Status
    extends ToXContentObject,
    NamedWriteable {
    }
}

