/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.PipelineAggregationBuilder;

public abstract class PipelineAggregator
implements NamedWriteable {
    private String name;
    private String[] bucketsPaths;
    private Map<String, Object> metadata;

    protected PipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metadata) {
        this.name = name;
        this.bucketsPaths = bucketsPaths;
        this.metadata = metadata;
    }

    @Deprecated
    protected PipelineAggregator(StreamInput in) throws IOException {
        if (!in.getVersion().before(LegacyESVersion.V_7_8_0)) {
            throw new IllegalStateException("Cannot deserialize pipeline [" + this.getClass() + "] from before 7.8.0");
        }
        this.name = in.readString();
        this.bucketsPaths = in.readStringArray();
        this.metadata = in.readMap();
    }

    @Override
    @Deprecated
    public final void writeTo(StreamOutput out) throws IOException {
        if (!out.getVersion().before(LegacyESVersion.V_7_8_0)) {
            throw new IllegalArgumentException("[" + this.name + "] is not supported on versions before 7.8.0");
        }
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metadata);
        this.doWriteTo(out);
    }

    @Deprecated
    protected void doWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    @Deprecated
    public String getWriteableName() {
        throw new IllegalArgumentException("[" + this.name + "] is not supported on versions before 7.8.0");
    }

    public String name() {
        return this.name;
    }

    public String[] bucketsPaths() {
        return this.bucketsPaths;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public abstract InternalAggregation reduce(InternalAggregation var1, InternalAggregation.ReduceContext var2);

    public static class PipelineTree {
        public static final PipelineTree EMPTY = new PipelineTree(Collections.emptyMap(), Collections.emptyList());
        private final Map<String, PipelineTree> subTrees;
        private final List<PipelineAggregator> aggregators;

        public PipelineTree(Map<String, PipelineTree> subTrees, List<PipelineAggregator> aggregators) {
            this.subTrees = subTrees;
            this.aggregators = aggregators;
        }

        public List<PipelineAggregator> aggregators() {
            return this.aggregators;
        }

        public PipelineTree subTree(String name) {
            return this.subTrees.getOrDefault(name, EMPTY);
        }

        public boolean hasSubTrees() {
            return false == this.subTrees.isEmpty();
        }

        public String toString() {
            return "PipelineTree[" + this.aggregators + "," + this.subTrees + "]";
        }
    }

    @FunctionalInterface
    public static interface Parser {
        public static final ParseField BUCKETS_PATH = new ParseField("buckets_path", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);

        public PipelineAggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

