/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;

public class VariableWidthHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<VariableWidthHistogramAggregationBuilder> {
    public static final String NAME = "variable_width_histogram";
    public static final ValuesSourceRegistry.RegistryKey<VariableWidthHistogramAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<VariableWidthHistogramAggregatorSupplier>("variable_width_histogram", VariableWidthHistogramAggregatorSupplier.class);
    private static final ParseField NUM_BUCKETS_FIELD = new ParseField("buckets", new String[0]);
    private static final ParseField INITIAL_BUFFER_FIELD = new ParseField("initial_buffer", new String[0]);
    private static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ObjectParser<VariableWidthHistogramAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("variable_width_histogram", VariableWidthHistogramAggregationBuilder::new);
    private int numBuckets = 10;
    private int shardSize = -1;
    private int initialBuffer = -1;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        VariableWidthHistogramAggregatorFactory.registerAggregators(builder);
    }

    public VariableWidthHistogramAggregationBuilder(String name) {
        super(name);
    }

    public VariableWidthHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.numBuckets = in.readVInt();
    }

    protected VariableWidthHistogramAggregationBuilder(VariableWidthHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.numBuckets = clone.numBuckets;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public VariableWidthHistogramAggregationBuilder setNumBuckets(int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be greater than [0] for [" + this.name + "]");
        }
        this.numBuckets = numBuckets;
        return this;
    }

    public VariableWidthHistogramAggregationBuilder setShardSize(int shardSize) {
        if (shardSize <= 1) {
            throw new IllegalArgumentException(SHARD_SIZE_FIELD.getPreferredName() + " must be greater than [1] for [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public VariableWidthHistogramAggregationBuilder setInitialBuffer(int initialBuffer) {
        if (initialBuffer <= 0) {
            throw new IllegalArgumentException(INITIAL_BUFFER_FIELD.getPreferredName() + " must be greater than [0] for [" + this.name + "]");
        }
        this.initialBuffer = initialBuffer;
        return this;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public int getShardSize() {
        if (this.shardSize == -1) {
            return this.numBuckets * 50;
        }
        return this.shardSize;
    }

    public int getInitialBuffer() {
        if (this.initialBuffer == -1) {
            return Math.min(10 * this.getShardSize(), 50000);
        }
        return this.initialBuffer;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new VariableWidthHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numBuckets);
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Settings settings = queryShardContext.getIndexSettings().getNodeSettings();
        int maxBuckets = MultiBucketConsumerService.MAX_BUCKET_SETTING.get(settings);
        if (this.numBuckets > maxBuckets) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be less than " + maxBuckets);
        }
        int initialBuffer = this.getInitialBuffer();
        int shardSize = this.getShardSize();
        if (initialBuffer < this.numBuckets) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s must be at least %s but was [%s<%s] for [%s]", INITIAL_BUFFER_FIELD.getPreferredName(), NUM_BUCKETS_FIELD.getPreferredName(), initialBuffer, this.numBuckets, this.name));
        }
        int mergePhaseInit = VariableWidthHistogramAggregator.mergePhaseInitialBucketCount(shardSize);
        if (mergePhaseInit < this.numBuckets) {
            throw new IllegalArgumentException("3/4 of " + SHARD_SIZE_FIELD.getPreferredName() + " must be at least " + NUM_BUCKETS_FIELD.getPreferredName() + " but was [" + mergePhaseInit + "<" + this.numBuckets + "] for [" + this.name + "]");
        }
        return new VariableWidthHistogramAggregatorFactory(this.name, config, this.numBuckets, shardSize, initialBuffer, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUM_BUCKETS_FIELD.getPreferredName(), this.numBuckets);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numBuckets, this.shardSize, this.initialBuffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        VariableWidthHistogramAggregationBuilder other = (VariableWidthHistogramAggregationBuilder)obj;
        return Objects.equals(this.numBuckets, other.numBuckets) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.initialBuffer, other.initialBuffer);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, true);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setNumBuckets, NUM_BUCKETS_FIELD);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setShardSize, SHARD_SIZE_FIELD);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setInitialBuffer, INITIAL_BUFFER_FIELD);
    }
}

