/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.KeyComparable;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeKey;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.MissingOrder;

public class InternalComposite
extends InternalMultiBucketAggregation<InternalComposite, InternalBucket>
implements CompositeAggregation {
    private final int size;
    private final List<InternalBucket> buckets;
    private final CompositeKey afterKey;
    private final int[] reverseMuls;
    private final MissingOrder[] missingOrders;
    private final List<String> sourceNames;
    private final List<DocValueFormat> formats;
    private final boolean earlyTerminated;

    InternalComposite(String name, int size, List<String> sourceNames, List<DocValueFormat> formats, List<InternalBucket> buckets, CompositeKey afterKey, int[] reverseMuls, MissingOrder[] missingOrders, boolean earlyTerminated, Map<String, Object> metadata) {
        super(name, metadata);
        this.sourceNames = sourceNames;
        this.formats = formats;
        this.buckets = buckets;
        this.afterKey = afterKey;
        this.size = size;
        this.reverseMuls = reverseMuls;
        this.missingOrders = missingOrders;
        this.earlyTerminated = earlyTerminated;
    }

    public InternalComposite(StreamInput in) throws IOException {
        super(in);
        this.size = in.readVInt();
        this.sourceNames = in.readStringList();
        this.formats = new ArrayList<DocValueFormat>(this.sourceNames.size());
        for (int i = 0; i < this.sourceNames.size(); ++i) {
            this.formats.add(in.readNamedWriteable(DocValueFormat.class));
        }
        this.reverseMuls = in.readIntArray();
        if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
            this.missingOrders = in.readArray(MissingOrder::readFromStream, MissingOrder[]::new);
        } else {
            this.missingOrders = new MissingOrder[this.reverseMuls.length];
            Arrays.fill(this.missingOrders, MissingOrder.DEFAULT);
        }
        this.buckets = in.readList(input -> new InternalBucket(input, this.sourceNames, this.formats, this.reverseMuls, this.missingOrders));
        this.afterKey = in.readBoolean() ? new CompositeKey(in) : null;
        this.earlyTerminated = in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0) ? in.readBoolean() : false;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.size);
        out.writeStringCollection(this.sourceNames);
        for (DocValueFormat format : this.formats) {
            out.writeNamedWriteable(format);
        }
        out.writeIntArray(this.reverseMuls);
        if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
            out.writeArray((output, order) -> order.writeTo(output), this.missingOrders);
        }
        out.writeList(this.buckets);
        out.writeBoolean(this.afterKey != null);
        if (this.afterKey != null) {
            this.afterKey.writeTo(out);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
            out.writeBoolean(this.earlyTerminated);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return CompositeAggregation.toXContentFragment(this, builder, params);
    }

    @Override
    public String getWriteableName() {
        return "composite";
    }

    @Override
    public InternalComposite create(List<InternalBucket> newBuckets) {
        return new InternalComposite(this.name, this.size, this.sourceNames, this.formats, newBuckets, this.afterKey, this.reverseMuls, this.missingOrders, this.earlyTerminated, this.getMetadata());
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.sourceNames, prototype.formats, prototype.key, prototype.reverseMuls, prototype.missingOrders, prototype.docCount, aggregations);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    List<DocValueFormat> getFormats() {
        return this.formats;
    }

    @Override
    public Map<String, Object> afterKey() {
        if (this.afterKey != null) {
            return new ArrayMap(this.sourceNames, this.formats, this.afterKey.values());
        }
        return null;
    }

    boolean isTerminatedEarly() {
        return this.earlyTerminated;
    }

    int[] getReverseMuls() {
        return this.reverseMuls;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue<BucketIterator> pq = new PriorityQueue<BucketIterator>(aggregations.size());
        boolean earlyTerminated = false;
        for (InternalAggregation agg : aggregations) {
            InternalComposite sortedAgg = (InternalComposite)agg;
            earlyTerminated |= sortedAgg.earlyTerminated;
            BucketIterator it = new BucketIterator(sortedAgg.buckets);
            if (it.next() == null) continue;
            pq.add(it);
        }
        InternalBucket lastBucket = null;
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>();
        ArrayList<InternalBucket> result = new ArrayList<InternalBucket>();
        while (pq.size() > 0) {
            BucketIterator bucketIt = (BucketIterator)pq.poll();
            if (lastBucket != null && bucketIt.current.compareKey(lastBucket) != 0) {
                InternalMultiBucketAggregation.InternalBucket reduceBucket = this.reduceBucket(buckets, reduceContext);
                buckets.clear();
                result.add((InternalBucket)reduceBucket);
                if (result.size() >= this.size) break;
            }
            lastBucket = bucketIt.current;
            buckets.add(bucketIt.current);
            if (bucketIt.next() == null) continue;
            pq.add(bucketIt);
        }
        if (buckets.size() > 0) {
            InternalMultiBucketAggregation.InternalBucket reduceBucket = this.reduceBucket(buckets, reduceContext);
            result.add((InternalBucket)reduceBucket);
        }
        List<DocValueFormat> reducedFormats = this.formats;
        CompositeKey lastKey = null;
        if (result.size() > 0) {
            lastBucket = (InternalBucket)result.get(result.size() - 1);
            reducedFormats = lastBucket.formats;
            lastKey = lastBucket.getRawKey();
        }
        reduceContext.consumeBucketsAndMaybeBreak(result.size());
        return new InternalComposite(this.name, this.size, this.sourceNames, reducedFormats, result, lastKey, this.reverseMuls, this.missingOrders, earlyTerminated, this.metadata);
    }

    @Override
    protected InternalBucket reduceBucket(List<InternalBucket> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
        long docCount = 0L;
        for (InternalBucket bucket : buckets) {
            docCount += bucket.docCount;
            aggregations.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
        List<DocValueFormat> reducedFormats = buckets.get((int)0).formats;
        return new InternalBucket(this.sourceNames, reducedFormats, buckets.get((int)0).key, this.reverseMuls, this.missingOrders, docCount, aggs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalComposite that = (InternalComposite)obj;
        return Objects.equals(this.size, that.size) && Objects.equals(this.buckets, that.buckets) && Objects.equals(this.afterKey, that.afterKey) && Arrays.equals(this.reverseMuls, that.reverseMuls) && Arrays.equals(this.missingOrders, that.missingOrders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.size, this.buckets, this.afterKey, Arrays.hashCode(this.reverseMuls), Arrays.hashCode(this.missingOrders));
    }

    static Object formatObject(Object obj, DocValueFormat format) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == BytesRef.class) {
            BytesRef value = (BytesRef)obj;
            if (format == DocValueFormat.RAW) {
                return value.utf8ToString();
            }
            return format.format(value);
        }
        if (obj.getClass() == Long.class) {
            long value = (Long)obj;
            if (format == DocValueFormat.RAW) {
                return value;
            }
            return format.format(value);
        }
        if (obj.getClass() == Double.class) {
            double value = (Double)obj;
            if (format == DocValueFormat.RAW) {
                return value;
            }
            return format.format(value);
        }
        return obj;
    }

    private static int compareNullables(Comparable a, Comparable b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements CompositeAggregation.Bucket,
    KeyComparable<InternalBucket> {
        private final CompositeKey key;
        private final long docCount;
        private final InternalAggregations aggregations;
        private final transient int[] reverseMuls;
        private final transient MissingOrder[] missingOrders;
        private final transient List<String> sourceNames;
        private final transient List<DocValueFormat> formats;

        InternalBucket(List<String> sourceNames, List<DocValueFormat> formats, CompositeKey key, int[] reverseMuls, MissingOrder[] missingOrders, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.reverseMuls = reverseMuls;
            this.missingOrders = missingOrders;
            this.sourceNames = sourceNames;
            this.formats = formats;
        }

        InternalBucket(StreamInput in, List<String> sourceNames, List<DocValueFormat> formats, int[] reverseMuls, MissingOrder[] missingOrders) throws IOException {
            this.key = new CompositeKey(in);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
            this.reverseMuls = reverseMuls;
            this.missingOrders = missingOrders;
            this.sourceNames = sourceNames;
            this.formats = formats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.key.writeTo(out);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.key, this.aggregations);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.key, that.key) && Objects.equals(this.aggregations, that.aggregations);
        }

        @Override
        public Map<String, Object> getKey() {
            return new ArrayMap(this.sourceNames, this.formats, this.key.values());
        }

        CompositeKey getRawKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            for (int i = 0; i < this.key.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.sourceNames.get(i));
                builder.append('=');
                builder.append(InternalComposite.formatObject(this.key.get(i), this.formats.get(i)));
            }
            builder.append('}');
            return builder.toString();
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        List<DocValueFormat> getFormats() {
            return this.formats;
        }

        @Override
        public int compareKey(InternalBucket other) {
            for (int i = 0; i < this.key.size(); ++i) {
                int index = i;
                int result = this.missingOrders[i].compare(() -> this.key.get(index) == null, () -> other.key.get(index) == null, this.reverseMuls[i]);
                if (!MissingOrder.unknownOrder(result)) {
                    if (result == 0) continue;
                    return result;
                }
                assert (this.key.get(i).getClass() == other.key.get(i).getClass());
                int cmp = this.key.get(i).compareTo(other.key.get(i)) * this.reverseMuls[i];
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    static class ArrayMap
    extends AbstractMap<String, Object>
    implements Comparable<ArrayMap> {
        final List<String> keys;
        final Comparable[] values;
        final List<DocValueFormat> formats;

        ArrayMap(List<String> keys, List<DocValueFormat> formats, Comparable[] values) {
            assert (keys.size() == values.length && keys.size() == formats.size());
            this.keys = keys;
            this.formats = formats;
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public Object get(Object key) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!key.equals(this.keys.get(i))) continue;
                return InternalComposite.formatObject(this.values[i], this.formats.get(i));
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return new Iterator<Map.Entry<String, Object>>(){
                        int pos = 0;

                        @Override
                        public boolean hasNext() {
                            return this.pos < values.length;
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(keys.get(this.pos), InternalComposite.formatObject(values[this.pos], formats.get(this.pos)));
                            ++this.pos;
                            return entry;
                        }
                    };
                }

                @Override
                public int size() {
                    return keys.size();
                }
            };
        }

        @Override
        public int compareTo(ArrayMap that) {
            int idx;
            if (that == this) {
                return 0;
            }
            int max = Math.min(this.keys.size(), that.keys.size());
            for (idx = 0; idx < max; ++idx) {
                int compare = InternalComposite.compareNullables((Comparable)((Object)this.keys.get(idx)), (Comparable)((Object)that.keys.get(idx)));
                if (compare == 0) {
                    compare = InternalComposite.compareNullables(this.values[idx], that.values[idx]);
                }
                if (compare == 0) continue;
                return compare;
            }
            if (idx < this.keys.size()) {
                return 1;
            }
            if (idx < that.keys.size()) {
                return -1;
            }
            return 0;
        }
    }

    private static class BucketIterator
    implements Comparable<BucketIterator> {
        final Iterator<InternalBucket> it;
        InternalBucket current;

        private BucketIterator(List<InternalBucket> buckets) {
            this.it = buckets.iterator();
        }

        @Override
        public int compareTo(BucketIterator other) {
            return this.current.compareKey(other.current);
        }

        InternalBucket next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            return this.current;
        }
    }
}

