/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.IndexSegments;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.IndexShardSegments;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.PitSegmentsAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.PitSegmentsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments.ShardSegments;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.common.Table;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Segment;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.RestTable;

public class RestPitSegmentsAction
extends AbstractCatAction {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestPitSegmentsAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/pit_segments/_all"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/pit_segments")));
    }

    @Override
    public String getName() {
        return "cat_pit_segments_action";
    }

    @Override
    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        PitSegmentsRequest pitSegmentsRequest;
        String allPitIdsQualifier = "_all";
        if (request.path().contains(allPitIdsQualifier)) {
            pitSegmentsRequest = new PitSegmentsRequest(allPitIdsQualifier);
        } else {
            pitSegmentsRequest = new PitSegmentsRequest();
            try {
                request.withContentOrSourceParamParserOrNull(xContentParser -> {
                    if (xContentParser != null) {
                        pitSegmentsRequest.fromXContent((XContentParser)xContentParser);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse request body", e);
            }
        }
        return channel -> client.execute(PitSegmentsAction.INSTANCE, pitSegmentsRequest, new RestResponseListener<IndicesSegmentResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesSegmentResponse indicesSegmentResponse) throws Exception {
                Map<String, IndexSegments> indicesSegments = indicesSegmentResponse.getIndices();
                Table tab = RestPitSegmentsAction.this.buildTable(request, indicesSegments);
                return RestTable.buildResponse(tab, this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/pit_segments\n");
        sb.append("/_cat/pit_segments/{pit_id}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("index", "default:true;alias:i,idx;desc:index name");
        table.addCell("shard", "default:true;alias:s,sh;desc:shard name");
        table.addCell("prirep", "alias:p,pr,primaryOrReplica;default:true;desc:primary or replica");
        table.addCell("ip", "default:true;desc:ip of node where it lives");
        table.addCell("id", "default:false;desc:unique id of node where it lives");
        table.addCell("segment", "default:true;alias:seg;desc:segment name");
        table.addCell("generation", "default:true;alias:g,gen;text-align:right;desc:segment generation");
        table.addCell("docs.count", "default:true;alias:dc,docsCount;text-align:right;desc:number of docs in segment");
        table.addCell("docs.deleted", "default:true;alias:dd,docsDeleted;text-align:right;desc:number of deleted docs in segment");
        table.addCell("size", "default:true;alias:si;text-align:right;desc:segment size in bytes");
        table.addCell("size.memory", "default:true;alias:sm,sizeMemory;text-align:right;desc:segment memory in bytes");
        table.addCell("committed", "default:true;alias:ic,isCommitted;desc:is segment committed");
        table.addCell("searchable", "default:true;alias:is,isSearchable;desc:is segment searched");
        table.addCell("version", "default:true;alias:v,ver;desc:version");
        table.addCell("compound", "default:true;alias:ico,isCompound;desc:is segment compound");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, Map<String, IndexSegments> indicesSegments) {
        Table table = this.getTableWithHeader(request);
        DiscoveryNodes nodes = this.nodesInCluster.get();
        for (IndexSegments indexSegments : indicesSegments.values()) {
            Map<Integer, IndexShardSegments> shards = indexSegments.getShards();
            for (IndexShardSegments indexShardSegments : shards.values()) {
                ShardSegments[] shardSegments;
                for (ShardSegments shardSegment : shardSegments = indexShardSegments.getShards()) {
                    List<Segment> segments = shardSegment.getSegments();
                    for (Segment segment : segments) {
                        table.startRow();
                        table.addCell(shardSegment.getShardRouting().getIndexName());
                        table.addCell(shardSegment.getShardRouting().getId());
                        table.addCell(shardSegment.getShardRouting().primary() ? "p" : "r");
                        table.addCell(nodes.get(shardSegment.getShardRouting().currentNodeId()).getHostAddress());
                        table.addCell(shardSegment.getShardRouting().currentNodeId());
                        table.addCell(segment.getName());
                        table.addCell(segment.getGeneration());
                        table.addCell(segment.getNumDocs());
                        table.addCell(segment.getDeletedDocs());
                        table.addCell(segment.getSize());
                        table.addCell(0L);
                        table.addCell(segment.isCommitted());
                        table.addCell(segment.isSearch());
                        table.addCell(segment.getVersion());
                        table.addCell(segment.isCompound());
                        table.endRow();
                    }
                }
            }
        }
        return table;
    }
}

