/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.IndexId;

public final class RepositoryShardId
implements Writeable {
    private final IndexId index;
    private final int shard;

    public RepositoryShardId(IndexId index, int shard) {
        assert (index != null);
        this.index = index;
        this.shard = shard;
    }

    public RepositoryShardId(StreamInput in) throws IOException {
        this(new IndexId(in), in.readVInt());
    }

    public IndexId index() {
        return this.index;
    }

    public String indexName() {
        return this.index.getName();
    }

    public int shardId() {
        return this.shard;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.shard);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryShardId)) {
            return false;
        }
        RepositoryShardId that = (RepositoryShardId)obj;
        return that.index.equals(this.index) && that.shard == this.shard;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shard);
    }

    public String toString() {
        return "RepositoryShardId{" + this.index + "}{" + this.shard + "}";
    }
}

