/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoryMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.LifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore.RemoteStoreShardShallowCopySnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreLockManagerFactory;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryState;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.IndexId;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryData;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryShardId;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryStats;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.ShardGenerations;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotInfo;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(ActionListener<RepositoryData> var1);

    @Deprecated
    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, Metadata var3);

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version var6, Function<ClusterState, ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version var4, ActionListener<RepositoryData> var5);

    default public void deleteSnapshotsAndReleaseLockFiles(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<RepositoryData> listener) {
        throw new UnsupportedOperationException();
    }

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    public long getRemoteUploadThrottleTimeInNanos();

    public long getRemoteDownloadThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public boolean isSystemRepository();

    public void snapshotShard(Store var1, MapperService var2, SnapshotId var3, IndexId var4, IndexCommit var5, @Nullable String var6, IndexShardSnapshotStatus var7, Version var8, Map<String, Object> var9, ActionListener<String> var10);

    default public void snapshotRemoteStoreIndexShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, long primaryTerm, long startTime, ActionListener<String> listener) {
        throw new UnsupportedOperationException();
    }

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    default public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        return Collections.emptyList();
    }

    default public RemoteStoreShardShallowCopySnapshot getRemoteStoreShallowCopyShardMetadata(SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId) {
        throw new UnsupportedOperationException();
    }

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    public void cloneShardSnapshot(SnapshotId var1, SnapshotId var2, RepositoryShardId var3, @Nullable String var4, ActionListener<String> var5);

    default public void cloneRemoteStoreIndexShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<String> listener) {
        throw new UnsupportedOperationException();
    }

    default public Map<String, Object> adaptUserMetadata(Map<String, Object> userMetadata) {
        return userMetadata;
    }

    default public boolean isReloadable() {
        return false;
    }

    default public void reload(RepositoryMetadata repositoryMetadata) {
    }

    default public void validateMetadata(RepositoryMetadata repositoryMetadata) {
    }

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }
    }
}

