/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.remotestore;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.CryptoMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoryMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;

public class RemoteStoreNodeAttribute {
    public static final String REMOTE_STORE_NODE_ATTRIBUTE_KEY_PREFIX = "remote_store";
    public static final String REMOTE_STORE_SEGMENT_REPOSITORY_NAME_ATTRIBUTE_KEY = "remote_store.segment.repository";
    public static final String REMOTE_STORE_TRANSLOG_REPOSITORY_NAME_ATTRIBUTE_KEY = "remote_store.translog.repository";
    public static final String REMOTE_STORE_CLUSTER_STATE_REPOSITORY_NAME_ATTRIBUTE_KEY = "remote_store.state.repository";
    public static final String REMOTE_STORE_REPOSITORY_TYPE_ATTRIBUTE_KEY_FORMAT = "remote_store.repository.%s.type";
    public static final String REMOTE_STORE_REPOSITORY_CRYPTO_ATTRIBUTE_KEY_FORMAT = "remote_store.repository.%s.crypto_metadata";
    public static final String REMOTE_STORE_REPOSITORY_CRYPTO_SETTINGS_PREFIX = "remote_store.repository.%s.crypto_metadata.settings";
    public static final String REMOTE_STORE_REPOSITORY_SETTINGS_ATTRIBUTE_KEY_PREFIX = "remote_store.repository.%s.settings.";
    private final RepositoriesMetadata repositoriesMetadata;

    public RemoteStoreNodeAttribute(DiscoveryNode node) {
        this.repositoriesMetadata = this.buildRepositoriesMetadata(node);
    }

    private String validateAttributeNonNull(DiscoveryNode node, String attributeKey) {
        String attributeValue = node.getAttributes().get(attributeKey);
        if (attributeValue == null || attributeValue.isEmpty()) {
            throw new IllegalStateException("joining node [" + node + "] doesn't have the node attribute [" + attributeKey + "]");
        }
        return attributeValue;
    }

    private CryptoMetadata buildCryptoMetadata(DiscoveryNode node, String repositoryName) {
        String metadataKey = String.format(Locale.getDefault(), REMOTE_STORE_REPOSITORY_CRYPTO_ATTRIBUTE_KEY_FORMAT, repositoryName);
        boolean isRepoEncrypted = node.getAttributes().keySet().stream().anyMatch(key -> key.startsWith(metadataKey));
        if (!isRepoEncrypted) {
            return null;
        }
        String keyProviderName = this.validateAttributeNonNull(node, metadataKey + ".key_provider_name");
        String keyProviderType = this.validateAttributeNonNull(node, metadataKey + ".key_provider_type");
        String settingsAttributeKeyPrefix = String.format(Locale.getDefault(), REMOTE_STORE_REPOSITORY_CRYPTO_SETTINGS_PREFIX, repositoryName);
        Map<String, String> settingsMap = node.getAttributes().keySet().stream().filter(key -> key.startsWith(settingsAttributeKeyPrefix)).collect(Collectors.toMap(key -> key.replace(settingsAttributeKeyPrefix + ".", ""), key -> node.getAttributes().get(key)));
        Settings.Builder settings = Settings.builder();
        settingsMap.forEach(settings::put);
        return new CryptoMetadata(keyProviderName, keyProviderType, settings.build());
    }

    private Map<String, String> validateSettingsAttributesNonNull(DiscoveryNode node, String repositoryName) {
        String settingsAttributeKeyPrefix = String.format(Locale.getDefault(), REMOTE_STORE_REPOSITORY_SETTINGS_ATTRIBUTE_KEY_PREFIX, repositoryName);
        Map<String, String> settingsMap = node.getAttributes().keySet().stream().filter(key -> key.startsWith(settingsAttributeKeyPrefix)).collect(Collectors.toMap(key -> key.replace(settingsAttributeKeyPrefix, ""), key -> this.validateAttributeNonNull(node, (String)key)));
        if (settingsMap.isEmpty()) {
            throw new IllegalStateException("joining node [" + node + "] doesn't have settings attribute for [" + repositoryName + "] repository");
        }
        return settingsMap;
    }

    private RepositoryMetadata buildRepositoryMetadata(DiscoveryNode node, String name) {
        String type = this.validateAttributeNonNull(node, String.format(Locale.getDefault(), REMOTE_STORE_REPOSITORY_TYPE_ATTRIBUTE_KEY_FORMAT, name));
        Map<String, String> settingsMap = this.validateSettingsAttributesNonNull(node, name);
        Settings.Builder settings = Settings.builder();
        settingsMap.forEach(settings::put);
        CryptoMetadata cryptoMetadata = this.buildCryptoMetadata(node, name);
        settings.put(BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.getKey(), true);
        return new RepositoryMetadata(name, type, settings.build(), cryptoMetadata);
    }

    private RepositoriesMetadata buildRepositoriesMetadata(DiscoveryNode node) {
        ArrayList<RepositoryMetadata> repositoryMetadataList = new ArrayList<RepositoryMetadata>();
        HashSet<String> repositoryNames = new HashSet<String>();
        repositoryNames.add(this.validateAttributeNonNull(node, REMOTE_STORE_SEGMENT_REPOSITORY_NAME_ATTRIBUTE_KEY));
        repositoryNames.add(this.validateAttributeNonNull(node, REMOTE_STORE_TRANSLOG_REPOSITORY_NAME_ATTRIBUTE_KEY));
        repositoryNames.add(this.validateAttributeNonNull(node, REMOTE_STORE_CLUSTER_STATE_REPOSITORY_NAME_ATTRIBUTE_KEY));
        for (String repositoryName : repositoryNames) {
            repositoryMetadataList.add(this.buildRepositoryMetadata(node, repositoryName));
        }
        return new RepositoriesMetadata(repositoryMetadataList);
    }

    public static boolean isRemoteStoreAttributePresent(Settings settings) {
        return !settings.getByPrefix(Node.NODE_ATTRIBUTES.getKey() + REMOTE_STORE_NODE_ATTRIBUTE_KEY_PREFIX).isEmpty();
    }

    public static boolean isRemoteStoreClusterStateEnabled(Settings settings) {
        return RemoteClusterStateService.REMOTE_CLUSTER_STATE_ENABLED_SETTING.get(settings) != false && RemoteStoreNodeAttribute.isRemoteStoreAttributePresent(settings);
    }

    public RepositoriesMetadata getRepositoriesMetadata() {
        return this.repositoriesMetadata;
    }

    public int hashCode() {
        int hashCode = 1;
        for (RepositoryMetadata repositoryMetadata : this.repositoriesMetadata.repositories()) {
            hashCode = 31 * hashCode + (repositoryMetadata == null ? 0 : Objects.hash(repositoryMetadata.name(), repositoryMetadata.type(), repositoryMetadata.settings()));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStoreNodeAttribute that = (RemoteStoreNodeAttribute)o;
        return this.getRepositoriesMetadata().equalsIgnoreGenerations(that.getRepositoriesMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append(this.repositoriesMetadata).append('}');
        return super.toString();
    }
}

