/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.join.mapper;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.SortedDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ContentPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocumentMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappingLookup;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.StringFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.join.mapper.MetaJoinFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.join.mapper.ParentIdFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public final class ParentJoinFieldMapper
extends FieldMapper {
    public static final String NAME = "join";
    public static final String CONTENT_TYPE = "join";
    private MetaJoinFieldMapper uniqueFieldMapper;
    private List<ParentIdFieldMapper> parentIdFields;
    private boolean eagerGlobalOrdinals;

    public static ParentJoinFieldMapper getMapper(MapperService service) {
        MetaJoinFieldMapper.MetaJoinFieldType fieldType = (MetaJoinFieldMapper.MetaJoinFieldType)service.fieldType("_parent_join");
        if (fieldType == null) {
            return null;
        }
        DocumentMapper mapper = service.documentMapper();
        String joinField = fieldType.getJoinField();
        MappingLookup fieldMappers = mapper.mappers();
        return (ParentJoinFieldMapper)fieldMappers.getMapper(joinField);
    }

    private static String getParentIdFieldName(String joinFieldName, String parentName) {
        return joinFieldName + "#" + parentName;
    }

    private static void checkIndexCompatibility(IndexSettings settings, String name) {
        if (settings.getIndexMetadata().isRoutingPartitionedIndex()) {
            throw new IllegalStateException("cannot create join field [" + name + "] for the partitioned index [" + settings.getIndex().getName() + "]");
        }
    }

    private static void checkObjectOrNested(ContentPath path, String name) {
        if (path.pathAsText(name).contains(".")) {
            throw new IllegalArgumentException("join field [" + path.pathAsText(name) + "] cannot be added inside an object or in a multi-field");
        }
    }

    private static void checkParentFields(String name, List<ParentIdFieldMapper> mappers) {
        HashSet<String> children = new HashSet<String>();
        ArrayList<CallSite> conflicts = new ArrayList<CallSite>();
        for (ParentIdFieldMapper mapper : mappers) {
            for (String child : mapper.getChildren()) {
                if (children.add(child)) continue;
                conflicts.add((CallSite)((Object)("[" + child + "] cannot have multiple parents")));
            }
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("invalid definition for join field [" + name + "]:\n" + ((Object)conflicts).toString());
        }
    }

    protected ParentJoinFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, MetaJoinFieldMapper uniqueFieldMapper, List<ParentIdFieldMapper> parentIdFields, boolean eagerGlobalOrdinals) {
        super(simpleName, fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.parentIdFields = parentIdFields;
        this.uniqueFieldMapper = uniqueFieldMapper;
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    @Override
    protected String contentType() {
        return "join";
    }

    @Override
    protected ParentJoinFieldMapper clone() {
        return (ParentJoinFieldMapper)super.clone();
    }

    @Override
    public JoinFieldType fieldType() {
        return (JoinFieldType)super.fieldType();
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<ParentIdFieldMapper> mappers = new ArrayList<ParentIdFieldMapper>(this.parentIdFields);
        mappers.add((ParentIdFieldMapper)((Object)this.uniqueFieldMapper));
        return mappers.iterator();
    }

    public boolean hasParent(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> name.equals(mapper.getParentName()));
    }

    public boolean hasChild(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> mapper.getChildren().contains(name));
    }

    public ParentIdFieldMapper getParentIdFieldMapper(String name, boolean isParent) {
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (isParent && name.equals(mapper.getParentName())) {
                return mapper;
            }
            if (isParent || !mapper.getChildren().contains(name)) continue;
            return mapper;
        }
        return null;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        ParentJoinFieldMapper joinMergeWith = (ParentJoinFieldMapper)other;
        ArrayList<ParentIdFieldMapper> newParentIdFields = new ArrayList<ParentIdFieldMapper>();
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (joinMergeWith.getParentIdFieldMapper(mapper.getParentName(), true) != null) continue;
            conflicts.add("cannot remove parent [" + mapper.getParentName() + "] in join field [" + this.name() + "]");
        }
        for (ParentIdFieldMapper mergeWithMapper : joinMergeWith.parentIdFields) {
            ParentIdFieldMapper self = this.getParentIdFieldMapper(mergeWithMapper.getParentName(), true);
            if (self == null) {
                if (this.getParentIdFieldMapper(mergeWithMapper.getParentName(), false) != null) {
                    conflicts.add("cannot create parent [" + mergeWithMapper.getParentName() + "] from an existing child");
                }
                for (String child : mergeWithMapper.getChildren()) {
                    if (this.getParentIdFieldMapper(child, true) == null) continue;
                    conflicts.add("cannot create child [" + child + "] from an existing parent");
                }
                newParentIdFields.add(mergeWithMapper);
                continue;
            }
            for (String child : self.getChildren()) {
                if (mergeWithMapper.getChildren().contains(child)) continue;
                conflicts.add("cannot remove child [" + child + "] in join field [" + this.name() + "]");
            }
            ParentIdFieldMapper merged = (ParentIdFieldMapper)self.merge(mergeWithMapper);
            newParentIdFields.add(merged);
        }
        this.eagerGlobalOrdinals = joinMergeWith.eagerGlobalOrdinals;
        this.parentIdFields = Collections.unmodifiableList(newParentIdFields);
        this.uniqueFieldMapper = (MetaJoinFieldMapper)this.uniqueFieldMapper.merge(joinMergeWith.uniqueFieldMapper);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ParseContext externalContext;
        context.path().add(this.simpleName());
        XContentParser.Token token = context.parser().currentToken();
        String name = null;
        String parent = null;
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = context.parser().currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("name".equals(currentFieldName)) {
                        name = context.parser().text();
                        continue;
                    }
                    if ("parent".equals(currentFieldName)) {
                        parent = context.parser().text();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("parent".equals(currentFieldName)) {
                    parent = context.parser().numberValue().toString();
                    continue;
                }
                throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            name = context.parser().text();
            parent = null;
        } else {
            throw new IllegalStateException("[" + name + "] expected START_OBJECT or VALUE_STRING but was: " + token);
        }
        ParentIdFieldMapper parentIdField = this.getParentIdFieldMapper(name, true);
        ParentIdFieldMapper childParentIdField = this.getParentIdFieldMapper(name, false);
        if (parentIdField == null && childParentIdField == null) {
            throw new IllegalArgumentException("unknown join name [" + name + "] for field [" + this.name() + "]");
        }
        if (childParentIdField != null) {
            if (parent == null) {
                throw new IllegalArgumentException("[parent] is missing for join field [" + this.name() + "]");
            }
            if (context.sourceToParse().routing() == null) {
                throw new IllegalArgumentException("[routing] is missing for join field [" + this.name() + "]");
            }
            assert (childParentIdField.getChildren().contains(name));
            externalContext = context.createExternalValueContext(parent);
            childParentIdField.parse(externalContext);
        }
        if (parentIdField != null) {
            assert (parentIdField.getParentName().equals(name));
            externalContext = context.createExternalValueContext(context.sourceToParse().id());
            parentIdField.parse(externalContext);
        }
        BytesRef binaryValue = new BytesRef(name);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType);
        context.doc().add(field);
        context.doc().add(new SortedDocValuesField(this.fieldType().name(), binaryValue));
        context.path().remove();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        builder.field("eager_global_ordinals", this.eagerGlobalOrdinals);
        builder.startObject("relations");
        for (ParentIdFieldMapper field : this.parentIdFields) {
            if (field.getChildren().size() == 1) {
                builder.field(field.getParentName(), field.getChildren().iterator().next());
                continue;
            }
            builder.field(field.getParentName(), field.getChildren());
        }
        builder.endObject();
    }

    public static final class JoinFieldType
    extends StringFieldType {
        private JoinFieldType(String name, Map<String, String> meta) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        @Override
        public String typeName() {
            return "join";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            IndexSettings indexSettings = parserContext.mapperService().getIndexSettings();
            ParentJoinFieldMapper.checkIndexCompatibility(indexSettings, name);
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                if ("type".equals(entry.getKey())) continue;
                if ("eager_global_ordinals".equals(entry.getKey())) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(entry.getValue(), "eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (!"relations".equals(entry.getKey())) continue;
                Map<String, Object> relations = XContentMapValues.nodeMapValue(entry.getValue(), "relations");
                for (Map.Entry<String, Object> relation : relations.entrySet()) {
                    String parent = relation.getKey();
                    Set<String> children = XContentMapValues.isArray(relation.getValue()) ? new HashSet<String>(Arrays.asList(XContentMapValues.nodeStringArrayValue(relation.getValue()))) : Collections.singleton(relation.getValue().toString());
                    builder.addParent(parent, children);
                }
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        final List<ParentIdFieldMapper.Builder> parentIdFieldBuilders = new ArrayList<ParentIdFieldMapper.Builder>();
        boolean eagerGlobalOrdinals = true;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder addParent(String parent, Set<String> children) {
            String parentIdFieldName = ParentJoinFieldMapper.getParentIdFieldName(this.name, parent);
            this.parentIdFieldBuilders.add(new ParentIdFieldMapper.Builder(parentIdFieldName, parent, children));
            return (Builder)this.builder;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        @Override
        public ParentJoinFieldMapper build(Mapper.BuilderContext context) {
            ParentJoinFieldMapper.checkObjectOrNested(context.path(), this.name);
            ArrayList<ParentIdFieldMapper> parentIdFields = new ArrayList<ParentIdFieldMapper>();
            this.parentIdFieldBuilders.stream().map(parentBuilder -> {
                if (this.eagerGlobalOrdinals) {
                    parentBuilder.eagerGlobalOrdinals(true);
                }
                return parentBuilder.build(context);
            }).forEach(parentIdFields::add);
            ParentJoinFieldMapper.checkParentFields(this.name(), parentIdFields);
            MetaJoinFieldMapper unique = new MetaJoinFieldMapper.Builder(this.name).build(context);
            return new ParentJoinFieldMapper(this.name, this.fieldType, new JoinFieldType(this.buildFullName(context), this.meta), unique, Collections.unmodifiableList(parentIdFields), this.eagerGlobalOrdinals);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

