/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.action.DocWriteRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.TransportBulkAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.index.IndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.DeletePipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateApplier;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.AckedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationMetrics;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.service.ReportingService;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.GatewayService;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.VersionType;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalysisRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.AbstractProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.CompoundProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ConditionalProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ConfigurationUtils;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestInfo;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestStats;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Pipeline;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.PipelineConfiguration;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.PipelineProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Processor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ProcessorInfo;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.WrappingProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.IngestPlugin;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class IngestService
implements ClusterStateApplier,
ReportingService<IngestInfo> {
    public static final String NOOP_PIPELINE_NAME = "_none";
    public static final String INGEST_ORIGIN = "ingest";
    private static final Logger logger = LogManager.getLogger(IngestService.class);
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory> processorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Collections.emptyMap();
    private final ThreadPool threadPool;
    private final OperationMetrics totalMetrics = new OperationMetrics();
    private final List<Consumer<ClusterState>> ingestClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private final ClusterManagerTaskThrottler.ThrottlingKey putPipelineTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deletePipelineTaskKey;
    private volatile ClusterState state;

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins, Client client) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.processorFactories = IngestService.processorFactories(ingestPlugins, new Processor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis(delay), "generic"), this, client, threadPool.generic()::execute));
        this.threadPool = threadPool;
        this.putPipelineTaskKey = clusterService.registerClusterManagerTask("put-pipeline", true);
        this.deletePipelineTaskKey = clusterService.registerClusterManagerTask("delete-pipeline", true);
    }

    private static Map<String, Processor.Factory> processorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    public static boolean resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        if (!indexRequest.isPipelineResolved()) {
            IndexAbstraction indexAbstraction;
            String requestPipeline = indexRequest.getPipeline();
            indexRequest.setPipeline(NOOP_PIPELINE_NAME);
            indexRequest.setFinalPipeline(NOOP_PIPELINE_NAME);
            String defaultPipeline = null;
            String finalPipeline = null;
            IndexMetadata indexMetadata = null;
            if (originalRequest != null) {
                indexMetadata = metadata.indices().get(originalRequest.index());
            }
            if (indexMetadata == null && indexRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexRequest.index())) != null) {
                indexMetadata = indexAbstraction.getWriteIndex();
            }
            if (indexMetadata == null && originalRequest != null && originalRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(originalRequest.index())) != null) {
                indexMetadata = indexAbstraction.getWriteIndex();
            }
            if (indexMetadata != null) {
                Settings indexSettings = indexMetadata.getSettings();
                if (IndexSettings.DEFAULT_PIPELINE.exists(indexSettings)) {
                    defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexSettings);
                    indexRequest.setPipeline(defaultPipeline);
                }
                if (IndexSettings.FINAL_PIPELINE.exists(indexSettings)) {
                    finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexSettings);
                    indexRequest.setFinalPipeline(finalPipeline);
                }
            } else if (indexRequest.index() != null) {
                String v2Template = MetadataIndexTemplateService.findV2Template(metadata, indexRequest.index(), false);
                if (v2Template != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings(metadata, v2Template);
                    if (IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                        defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                    }
                    if (IndexSettings.FINAL_PIPELINE.exists(settings)) {
                        finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                    }
                    indexRequest.setPipeline(defaultPipeline != null ? defaultPipeline : NOOP_PIPELINE_NAME);
                    indexRequest.setFinalPipeline(finalPipeline != null ? finalPipeline : NOOP_PIPELINE_NAME);
                } else {
                    List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findV1Templates(metadata, indexRequest.index(), null);
                    for (IndexTemplateMetadata template : templates) {
                        Settings settings = template.settings();
                        if (defaultPipeline == null && IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                            defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                        }
                        if (finalPipeline == null && IndexSettings.FINAL_PIPELINE.exists(settings)) {
                            finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                        }
                        if (defaultPipeline == null || finalPipeline == null) continue;
                        break;
                    }
                    indexRequest.setPipeline(defaultPipeline != null ? defaultPipeline : NOOP_PIPELINE_NAME);
                    indexRequest.setFinalPipeline(finalPipeline != null ? finalPipeline : NOOP_PIPELINE_NAME);
                }
            }
            if (requestPipeline != null) {
                indexRequest.setPipeline(requestPipeline);
            }
            indexRequest.isPipelineResolved(true);
        }
        return !NOOP_PIPELINE_NAME.equals(indexRequest.getPipeline()) || !NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline());
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void delete(final DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerDelete(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.deletePipelineTaskKey;
            }
        });
    }

    static ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelinesCopy)).build());
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetadata().custom(INGEST_ORIGIN);
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        this.clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerPut(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.putPipelineTaskKey;
            }
        });
    }

    public Pipeline getPipeline(String id) {
        PipelineHolder holder = this.pipelines.get(id);
        if (holder != null) {
            return holder.pipeline;
        }
        return null;
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    @Override
    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, PipelineHolder> pipelines() {
        return this.pipelines;
    }

    private static List<Tuple<Processor, OperationMetrics>> getProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<Processor, OperationMetrics>> processorMetrics) {
        for (Tuple<Processor, OperationMetrics> processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            Processor processor = processorWithMetric.v1();
            OperationMetrics metric = processorWithMetric.v2();
            if (processor instanceof CompoundProcessor) {
                IngestService.getProcessorMetrics((CompoundProcessor)processor, processorMetrics);
                continue;
            }
            if (processor instanceof ConditionalProcessor) {
                metric = ((ConditionalProcessor)processor).getMetric();
            }
            processorMetrics.add(new Tuple<Processor, OperationMetrics>(processor, metric));
        }
        return processorMetrics;
    }

    public static ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getMediaType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Map<String, Object> pipelineConfig = XContentHelper.convertToMap(request.getSource(), false, request.getMediaType()).v2();
        Pipeline pipeline = Pipeline.create(request.getId(), pipelineConfig, this.processorFactories, this.scriptService);
        ArrayList<OpenSearchException> exceptions = new ArrayList<OpenSearchException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + entry.getKey() + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void executeBulkRequest(final int numberOfActionRequests, final Iterable<DocWriteRequest<?>> actionRequests, final BiConsumer<Integer, Exception> onFailure, final BiConsumer<Thread, Exception> onCompletion, final IntConsumer onDropped, String executorName) {
        this.threadPool.executor(executorName).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onCompletion.accept(null, e);
            }

            @Override
            protected void doRun() {
                Thread originalThread = Thread.currentThread();
                AtomicInteger counter = new AtomicInteger(numberOfActionRequests);
                int i = 0;
                for (DocWriteRequest actionRequest : actionRequests) {
                    List<String> pipelines;
                    IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
                    if (indexRequest == null) {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    String pipelineId = indexRequest.getPipeline();
                    indexRequest.setPipeline(IngestService.NOOP_PIPELINE_NAME);
                    String finalPipelineId = indexRequest.getFinalPipeline();
                    indexRequest.setFinalPipeline(IngestService.NOOP_PIPELINE_NAME);
                    boolean hasFinalPipeline = true;
                    if (!IngestService.NOOP_PIPELINE_NAME.equals(pipelineId) && !IngestService.NOOP_PIPELINE_NAME.equals(finalPipelineId)) {
                        pipelines = Arrays.asList(pipelineId, finalPipelineId);
                    } else if (!IngestService.NOOP_PIPELINE_NAME.equals(pipelineId)) {
                        pipelines = Collections.singletonList(pipelineId);
                        hasFinalPipeline = false;
                    } else if (!IngestService.NOOP_PIPELINE_NAME.equals(finalPipelineId)) {
                        pipelines = Collections.singletonList(finalPipelineId);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    IngestService.this.executePipelines(i, pipelines.iterator(), hasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    ++i;
                }
            }
        });
    }

    private void executePipelines(int slot, Iterator<String> it, boolean hasFinalPipeline, IndexRequest indexRequest, IntConsumer onDropped, BiConsumer<Integer, Exception> onFailure, AtomicInteger counter, BiConsumer<Thread, Exception> onCompletion, Thread originalThread) {
        while (it.hasNext()) {
            String pipelineId = it.next();
            try {
                PipelineHolder holder = this.pipelines.get(pipelineId);
                if (holder == null) {
                    throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
                }
                Pipeline pipeline = holder.pipeline;
                String originalIndex = indexRequest.indices()[0];
                this.innerExecute(slot, indexRequest, pipeline, onDropped, e -> {
                    if (e != null) {
                        logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e);
                        onFailure.accept(slot, (Exception)e);
                    }
                    Iterator<Object> newIt = it;
                    boolean newHasFinalPipeline = hasFinalPipeline;
                    String newIndex = indexRequest.indices()[0];
                    if (!Objects.equals(originalIndex, newIndex)) {
                        if (hasFinalPipeline && !it.hasNext()) {
                            this.totalMetrics.failed();
                            onFailure.accept(slot, new IllegalStateException("final pipeline [" + pipelineId + "] can't change the target index"));
                        } else {
                            it.forEachRemaining($ -> {});
                            indexRequest.isPipelineResolved(false);
                            IngestService.resolvePipelines(null, indexRequest, this.state.metadata());
                            if (!NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline())) {
                                newIt = Collections.singleton(indexRequest.getFinalPipeline()).iterator();
                                newHasFinalPipeline = true;
                            } else {
                                newIt = Collections.emptyIterator();
                            }
                        }
                    }
                    if (newIt.hasNext()) {
                        this.executePipelines(slot, (Iterator<String>)newIt, newHasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                    }
                });
            }
            catch (Exception e2) {
                logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e2);
                onFailure.accept(slot, e2);
                if (counter.decrementAndGet() == 0) {
                    onCompletion.accept(originalThread, null);
                }
                assert (counter.get() >= 0);
                break;
            }
        }
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, holder) -> {
            Pipeline pipeline = holder.pipeline;
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics((String)id, pipeline.getMetrics());
            ArrayList<Tuple<Processor, OperationMetrics>> processorMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
            IngestService.getProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                Processor processor = (Processor)t.v1();
                OperationMetrics processorMetric = (OperationMetrics)t.v2();
                statsBuilder.addProcessorMetrics((String)id, IngestService.getProcessorName(processor), processor.getType(), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    public void addIngestClusterStateListener(Consumer<ClusterState> listener) {
        this.ingestClusterStateListeners.add(listener);
    }

    static String getProcessorName(Processor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            processor = ((ConditionalProcessor)processor).getInnerProcessor();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (processor instanceof PipelineProcessor) {
            String pipelineName = ((PipelineProcessor)processor).getPipelineTemplate().newInstance(Collections.emptyMap()).execute();
            sb.append(":");
            sb.append(pipelineName);
        }
        if ((tag = processor.getTag()) != null && !tag.isEmpty()) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private void innerExecute(int slot, IndexRequest indexRequest, Pipeline pipeline, IntConsumer itemDroppedHandler, Consumer<Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(null);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        this.totalMetrics.before();
        String index = indexRequest.index();
        String id = indexRequest.id();
        String routing = indexRequest.routing();
        Long version = indexRequest.version();
        VersionType versionType = indexRequest.versionType();
        Map<String, Object> sourceAsMap = indexRequest.sourceAsMap();
        IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, sourceAsMap);
        ingestDocument.executePipeline(pipeline, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
            this.totalMetrics.after(ingestTimeInMillis);
            if (e != null) {
                this.totalMetrics.failed();
                handler.accept((Exception)e);
            } else if (result == null) {
                itemDroppedHandler.accept(slot);
                handler.accept(null);
            } else {
                Map<IngestDocument.Metadata, Object> metadataMap = ingestDocument.extractMetadata();
                indexRequest.index((String)metadataMap.get((Object)IngestDocument.Metadata.INDEX));
                indexRequest.id((String)metadataMap.get((Object)IngestDocument.Metadata.ID));
                indexRequest.routing((String)metadataMap.get((Object)IngestDocument.Metadata.ROUTING));
                indexRequest.version(((Number)metadataMap.get((Object)IngestDocument.Metadata.VERSION)).longValue());
                if (metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE) != null) {
                    indexRequest.versionType(VersionType.fromString((String)metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE)));
                }
                if (metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO) != null) {
                    indexRequest.setIfSeqNo(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO)).longValue());
                }
                if (metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM) != null) {
                    indexRequest.setIfPrimaryTerm(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM)).longValue());
                }
                indexRequest.source(ingestDocument.getSourceAndMetadata(), indexRequest.getContentType());
                handler.accept(null);
            }
        });
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.ingestClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        IngestMetadata newIngestMetadata = (IngestMetadata)this.state.getMetadata().custom(INGEST_ORIGIN);
        if (newIngestMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newIngestMetadata);
        }
        catch (OpenSearchParseException e) {
            logger.warn("failed to update ingest pipelines", (Throwable)e);
        }
    }

    void innerUpdatePipelines(IngestMetadata newIngestMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<OpenSearchParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newIngestMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                Pipeline newPipeline = Pipeline.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.processorFactories, this.scriptService);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                Pipeline oldPipeline = previous.pipeline;
                newPipeline.getMetrics().add(oldPipeline.getMetrics());
                ArrayList<Tuple<Processor, OperationMetrics>> oldPerProcessMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
                ArrayList<Tuple<Processor, OperationMetrics>> newPerProcessMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
                IngestService.getProcessorMetrics(oldPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                IngestService.getProcessorMetrics(newPipeline.getCompoundProcessor(), newPerProcessMetrics);
                if (newPerProcessMetrics.size() != oldPerProcessMetrics.size()) continue;
                Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                for (Tuple tuple : newPerProcessMetrics) {
                    String type = ((Processor)tuple.v1()).getType();
                    OperationMetrics metric = (OperationMetrics)tuple.v2();
                    if (!oldMetricsIterator.hasNext()) continue;
                    Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                    String oldType = ((Processor)oldCompositeMetric.v1()).getType();
                    OperationMetrics oldMetric = (OperationMetrics)oldCompositeMetric.v2();
                    if (!type.equals(oldType)) continue;
                    metric.add(oldMetric);
                }
            }
            catch (OpenSearchParseException e) {
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), e);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList<OpenSearchParseException>();
                }
                exceptions.add(e);
            }
            catch (Exception e) {
                OpenSearchParseException parseException = new OpenSearchParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), parseException);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newIngestMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Collections.unmodifiableMap(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public <P extends Processor> List<P> getProcessorsInPipeline(String pipelineId, Class<P> clazz) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        ArrayList<Processor> processors = new ArrayList<Processor>();
        block0: for (Processor processor : pipeline.flattenAllProcessors()) {
            if (clazz.isAssignableFrom(processor.getClass())) {
                processors.add((Processor)clazz.cast(processor));
            }
            while (processor instanceof WrappingProcessor) {
                WrappingProcessor wrappingProcessor = (WrappingProcessor)processor;
                if (clazz.isAssignableFrom(wrappingProcessor.getInnerProcessor().getClass())) {
                    processors.add((Processor)clazz.cast(wrappingProcessor.getInnerProcessor()));
                }
                if (wrappingProcessor != (processor = wrappingProcessor.getInnerProcessor())) continue;
                continue block0;
            }
        }
        return processors;
    }

    private static Pipeline substitutePipeline(String id, OpenSearchParseException e) {
        String tag = e.getHeaderKeys().contains("processor_tag") ? e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        AbstractProcessor failureProcessor = new AbstractProcessor(tag, "this is a placeholder processor"){

            @Override
            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            @Override
            public String getType() {
                return type;
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, new CompoundProcessor(failureProcessor));
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final Pipeline pipeline;

        PipelineHolder(PipelineConfiguration configuration, Pipeline pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }
}

