/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public abstract class SegmentReplicationTransportRequest
extends TransportRequest {
    private final long replicationId;
    private final String targetAllocationId;
    private final DiscoveryNode targetNode;

    protected SegmentReplicationTransportRequest(long replicationId, String targetAllocationId, DiscoveryNode targetNode) {
        this.replicationId = replicationId;
        this.targetAllocationId = targetAllocationId;
        this.targetNode = targetNode;
    }

    protected SegmentReplicationTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.replicationId = in.readLong();
        this.targetAllocationId = in.readString();
        this.targetNode = new DiscoveryNode(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.replicationId);
        out.writeString(this.targetAllocationId);
        this.targetNode.writeTo(out);
    }

    public long getReplicationId() {
        return this.replicationId;
    }

    public String getTargetAllocationId() {
        return this.targetAllocationId;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public String toString() {
        return "SegmentReplicationTransportRequest{replicationId=" + this.replicationId + ", targetAllocationId='" + this.targetAllocationId + "', targetNode=" + this.targetNode + "}";
    }
}

