/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RateLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ChannelActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CancellableThreads;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRefCounted;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.FileChunkRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryTransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationRequestTracker;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationState;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;

public abstract class ReplicationTarget
extends AbstractRefCounted {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private volatile long lastAccessTime = System.nanoTime();
    private final ReplicationRequestTracker requestTracker = new ReplicationRequestTracker();
    private final long id;
    protected final AtomicBoolean finished = new AtomicBoolean();
    protected final IndexShard indexShard;
    protected final Store store;
    protected final ReplicationListener listener;
    protected final Logger logger;
    protected final CancellableThreads cancellableThreads;
    protected final ReplicationLuceneIndex stateIndex;

    protected abstract String getPrefix();

    protected abstract void onDone();

    protected void onCancel(String reason) {
        this.cancellableThreads.cancel(reason);
    }

    public abstract ReplicationState state();

    public abstract ReplicationTarget retryCopy();

    public abstract String description();

    public ReplicationListener getListener() {
        return this.listener;
    }

    public CancellableThreads cancellableThreads() {
        return this.cancellableThreads;
    }

    public abstract void notifyListener(ReplicationFailedException var1, boolean var2);

    public ReplicationTarget(String name, IndexShard indexShard, ReplicationLuceneIndex stateIndex, ReplicationListener listener) {
        super(name);
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
        this.listener = listener;
        this.id = ID_GENERATOR.incrementAndGet();
        this.stateIndex = stateIndex;
        this.indexShard = indexShard;
        this.store = indexShard.store();
        this.cancellableThreads = new CancellableThreads();
        this.store.incRef();
    }

    public long getId() {
        return this.id;
    }

    public abstract boolean reset(CancellableThreads var1) throws IOException;

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.nanoTime();
    }

    @Nullable
    public ActionListener<Void> markRequestReceivedAndCreateListener(long requestSeqNo, ActionListener<Void> listener) {
        return this.requestTracker.markReceivedAndCreateListener(requestSeqNo, listener);
    }

    public IndexShard indexShard() {
        this.ensureRefCount();
        return this.indexShard;
    }

    public Store store() {
        this.ensureRefCount();
        return this.store;
    }

    public ShardId shardId() {
        return this.indexShard.shardId();
    }

    public void markAsDone() {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.onDone();
            }
            finally {
                this.decRef();
            }
            this.listener.onDone(this.state());
        }
    }

    public void cancel(String reason) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("replication cancelled (reason: [{}])", (Object)reason);
                this.onCancel(reason);
            }
            finally {
                this.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ReplicationFailedException e, boolean sendShardFailure) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("marking target " + this.description() + " as failed", (Throwable)e);
                this.notifyListener(e, sendShardFailure);
            }
            finally {
                try {
                    this.cancellableThreads.cancel("failed" + this.description() + "[" + ExceptionsHelper.stackTrace(e) + "]");
                }
                finally {
                    this.decRef();
                }
            }
        }
    }

    protected void ensureRefCount() {
        if (this.refCount() <= 0) {
            throw new OpenSearchException("ReplicationTarget is used but it's refcount is 0. Probably a mismatch between incRef/decRef calls", new Object[0]);
        }
    }

    @Nullable
    public ActionListener<Void> createOrFinishListener(TransportChannel channel, String action, RecoveryTransportRequest request) {
        return this.createOrFinishListener(channel, action, request, nullVal -> TransportResponse.Empty.INSTANCE);
    }

    @Nullable
    public ActionListener<Void> createOrFinishListener(TransportChannel channel, String action, RecoveryTransportRequest request, CheckedFunction<Void, TransportResponse, Exception> responseFn) {
        ChannelActionListener channelListener = new ChannelActionListener(channel, action, request);
        ActionListener<Void> voidListener = ActionListener.map(channelListener, responseFn);
        long requestSeqNo = request.requestSeqNo();
        ActionListener<Void> listener = requestSeqNo != -2L ? this.markRequestReceivedAndCreateListener(requestSeqNo, voidListener) : voidListener;
        return listener;
    }

    public void handleFileChunk(FileChunkRequest request, ReplicationTarget replicationTarget, AtomicLong bytesSinceLastPause, RateLimiter rateLimiter, ActionListener<Void> listener) throws IOException {
        long bytes;
        if (listener == null) {
            return;
        }
        ReplicationLuceneIndex indexState = replicationTarget.state().getIndex();
        if (request.sourceThrottleTimeInNanos() != -1L) {
            indexState.addSourceThrottling(request.sourceThrottleTimeInNanos());
        }
        if (rateLimiter != null && (bytes = bytesSinceLastPause.addAndGet(request.content().length())) > rateLimiter.getMinPauseCheckBytes()) {
            bytesSinceLastPause.addAndGet(-bytes);
            long throttleTimeInNanos = rateLimiter.pause(bytes);
            indexState.addTargetThrottling(throttleTimeInNanos);
            replicationTarget.indexShard().recoveryStats().addThrottleTime(throttleTimeInNanos);
        }
        this.writeFileChunk(request.metadata(), request.position(), request.content(), request.lastChunk(), request.totalTranslogOps(), listener);
    }

    public abstract void writeFileChunk(StoreFileMetadata var1, long var2, BytesReference var4, boolean var5, int var6, ActionListener<Void> var7);

    @Override
    protected void closeInternal() {
        this.store.decRef();
    }
}

