/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.AutoCloseableRefCounted;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationTarget;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class ReplicationCollection<T extends ReplicationTarget> {
    private final ConcurrentMap<Long, T> onGoingTargetEvents = ConcurrentCollections.newConcurrentMap();
    private final Logger logger;
    private final ThreadPool threadPool;

    public ReplicationCollection(Logger logger, ThreadPool threadPool) {
        this.logger = logger;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startSafe(T target, TimeValue activityTimeout) {
        ConcurrentMap<Long, T> concurrentMap = this.onGoingTargetEvents;
        synchronized (concurrentMap) {
            boolean isPresent = this.onGoingTargetEvents.values().stream().map(ReplicationTarget::shardId).anyMatch(t -> t.equals(target.shardId()));
            if (isPresent) {
                throw new ReplicationFailedException("Shard " + ((ReplicationTarget)target).shardId() + " is already replicating");
            }
            return this.start(target, activityTimeout);
        }
    }

    public long start(T target, TimeValue activityTimeout) {
        this.startInternal(target, activityTimeout);
        return ((ReplicationTarget)target).getId();
    }

    private void startInternal(T target, TimeValue activityTimeout) {
        ReplicationTarget existingTarget = (ReplicationTarget)this.onGoingTargetEvents.putIfAbsent(((ReplicationTarget)target).getId(), target);
        assert (existingTarget == null) : "found two Target instances with the same id";
        this.logger.trace("started {}", (Object)((ReplicationTarget)target).description());
        this.threadPool.schedule(new ReplicationMonitor(((ReplicationTarget)target).getId(), ((ReplicationTarget)target).lastAccessTime(), activityTimeout), activityTimeout, "generic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T reset(long id, TimeValue activityTimeout) {
        ReplicationTarget oldTarget = null;
        try {
            ReplicationTarget newTarget;
            ConcurrentMap<Long, T> concurrentMap = this.onGoingTargetEvents;
            synchronized (concurrentMap) {
                oldTarget = (ReplicationTarget)this.onGoingTargetEvents.remove(id);
                if (oldTarget == null) {
                    return null;
                }
                newTarget = oldTarget.retryCopy();
                this.startInternal(newTarget, activityTimeout);
            }
            boolean successfulReset = oldTarget.reset(newTarget.cancellableThreads());
            if (successfulReset) {
                this.logger.trace("restarted {}, previous id [{}]", (Object)newTarget.description(), (Object)oldTarget.getId());
                return (T)newTarget;
            }
            this.logger.trace("{} could not be reset as it is already cancelled, previous id [{}]", (Object)newTarget.description(), (Object)oldTarget.getId());
            this.cancel(newTarget.getId(), "cancelled during reset");
            return null;
        }
        catch (Exception e) {
            assert (oldTarget != null);
            oldTarget.notifyListener(new ReplicationFailedException("Unable to reset target", (Throwable)e), true);
            return null;
        }
    }

    public T getTarget(long id) {
        return (T)((ReplicationTarget)this.onGoingTargetEvents.get(id));
    }

    public ReplicationRef<T> get(long id) {
        ReplicationTarget status = (ReplicationTarget)this.onGoingTargetEvents.get(id);
        if (status != null && status.tryIncRef()) {
            return new ReplicationRef<ReplicationTarget>(status);
        }
        return null;
    }

    public ReplicationRef<T> getSafe(long id, ShardId shardId) {
        ReplicationRef<T> ref = this.get(id);
        if (ref == null) {
            throw new IndexShardClosedException(shardId);
        }
        assert (((ReplicationTarget)ref.get()).indexShard().shardId().equals(shardId));
        return ref;
    }

    public boolean cancel(long id, String reason) {
        ReplicationTarget removed = (ReplicationTarget)this.onGoingTargetEvents.remove(id);
        boolean cancelled = false;
        if (removed != null) {
            this.logger.trace("canceled {} (reason [{}])", (Object)removed.description(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    public void fail(long id, ReplicationFailedException e, boolean sendShardFailure) {
        ReplicationTarget removed = (ReplicationTarget)this.onGoingTargetEvents.remove(id);
        if (removed != null) {
            this.logger.trace("failing {}. Send shard failure: [{}]", (Object)removed.description(), (Object)sendShardFailure);
            removed.fail(e, sendShardFailure);
        }
    }

    public void markAsDone(long id) {
        ReplicationTarget removed = (ReplicationTarget)this.onGoingTargetEvents.remove(id);
        if (removed != null) {
            this.logger.trace("Marking {} as done", (Object)removed.description());
            removed.markAsDone();
        }
    }

    public int size() {
        return this.onGoingTargetEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelForShard(ShardId shardId, String reason) {
        boolean cancelled = false;
        ArrayList<ReplicationTarget> matchedTargets = new ArrayList<ReplicationTarget>();
        ConcurrentMap<Long, T> concurrentMap = this.onGoingTargetEvents;
        synchronized (concurrentMap) {
            Iterator it = this.onGoingTargetEvents.values().iterator();
            while (it.hasNext()) {
                ReplicationTarget status = (ReplicationTarget)it.next();
                if (!status.indexShard().shardId().equals(shardId)) continue;
                matchedTargets.add(status);
                it.remove();
            }
        }
        for (ReplicationTarget removed : matchedTargets) {
            this.logger.trace("canceled {} (reason [{}])", (Object)removed.description(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    public void requestCancel(ShardId shardId, String reason) {
        for (ReplicationTarget value : this.onGoingTargetEvents.values()) {
            if (!value.shardId().equals(shardId)) continue;
            value.cancel(reason);
        }
    }

    public T getOngoingReplicationTarget(ShardId shardId) {
        List replicationTargetList = this.onGoingTargetEvents.values().stream().filter(t -> t.indexShard.shardId().equals(shardId)).collect(Collectors.toList());
        assert (replicationTargetList.size() <= 1) : "More than one on-going replication targets";
        return (T)(replicationTargetList.size() > 0 ? (ReplicationTarget)replicationTargetList.get(0) : null);
    }

    private class ReplicationMonitor
    extends AbstractRunnable {
        private final long id;
        private final TimeValue checkInterval;
        private volatile long lastSeenAccessTime;

        private ReplicationMonitor(long id, long lastSeenAccessTime, TimeValue checkInterval) {
            this.id = id;
            this.checkInterval = checkInterval;
            this.lastSeenAccessTime = lastSeenAccessTime;
        }

        @Override
        public void onFailure(Exception e) {
            ReplicationCollection.this.logger.error(() -> new ParameterizedMessage("unexpected error while monitoring [{}]", (Object)this.id), (Throwable)e);
        }

        @Override
        protected void doRun() throws Exception {
            ReplicationTarget status = (ReplicationTarget)ReplicationCollection.this.onGoingTargetEvents.get(this.id);
            if (status == null) {
                ReplicationCollection.this.logger.trace("[monitor] no status found for [{}], shutting down", (Object)this.id);
                return;
            }
            long accessTime = status.lastAccessTime();
            if (accessTime == this.lastSeenAccessTime) {
                String message = "no activity after [" + this.checkInterval + "]";
                ReplicationCollection.this.fail(this.id, new ReplicationFailedException(message), true);
                return;
            }
            this.lastSeenAccessTime = accessTime;
            ReplicationCollection.this.logger.trace("[monitor] rescheduling check for [{}]. last access time is [{}]", (Object)this.id, (Object)this.lastSeenAccessTime);
            ReplicationCollection.this.threadPool.schedule(this, this.checkInterval, "generic");
        }
    }

    public static class ReplicationRef<T extends ReplicationTarget>
    extends AutoCloseableRefCounted<T> {
        public ReplicationRef(T status) {
            super(status);
            ((ReplicationTarget)status).setLastAccessTime();
        }
    }
}

