/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardState;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class RemoteStoreReplicationSource
implements SegmentReplicationSource {
    private static final Logger logger = LogManager.getLogger(RemoteStoreReplicationSource.class);
    private final IndexShard indexShard;
    private final RemoteSegmentStoreDirectory remoteDirectory;

    public RemoteStoreReplicationSource(IndexShard indexShard) {
        this.indexShard = indexShard;
        FilterDirectory remoteStoreDirectory = (FilterDirectory)indexShard.remoteStore().directory();
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)byteSizeCachingStoreDirectory.getDelegate();
    }

    @Override
    public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
        try (GatedCloseable<SegmentInfos> segmentInfosSnapshot = this.indexShard.getSegmentInfosSnapshot();){
            Version version = segmentInfosSnapshot.get().getCommitLuceneVersion();
            RemoteSegmentMetadata mdFile = this.remoteDirectory.init();
            if (mdFile == null && !this.indexShard.state().equals((Object)IndexShardState.STARTED)) {
                listener.onResponse(new CheckpointInfoResponse(checkpoint, Collections.emptyMap(), null));
                return;
            }
            assert (mdFile != null) : "Remote metadata file can't be null if shard is active " + this.indexShard.state();
            Map<String, StoreFileMetadata> metadataMap = mdFile.getMetadata().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new StoreFileMetadata(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getOriginalFilename(), ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getLength(), Store.digestToString(Long.valueOf(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getChecksum())), version, null)));
            listener.onResponse(new CheckpointInfoResponse(mdFile.getReplicationCheckpoint(), metadataMap, mdFile.getSegmentInfosBytes()));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, IndexShard indexShard, ActionListener<GetSegmentFilesResponse> listener) {
        try {
            if (filesToFetch.isEmpty()) {
                listener.onResponse(new GetSegmentFilesResponse(Collections.emptyList()));
                return;
            }
            logger.debug("Downloading segment files from remote store {}", filesToFetch);
            RemoteSegmentMetadata remoteSegmentMetadata = this.remoteDirectory.readLatestMetadataFile();
            List<String> directoryFiles = List.of(indexShard.store().directory().listAll());
            if (remoteSegmentMetadata != null) {
                try {
                    indexShard.store().incRef();
                    indexShard.remoteStore().incRef();
                    Directory storeDirectory = indexShard.store().directory();
                    ArrayList<String> toDownloadSegmentNames = new ArrayList<String>();
                    for (StoreFileMetadata fileMetadata : filesToFetch) {
                        String file = fileMetadata.name();
                        assert (!directoryFiles.contains(file)) : "Local store already contains the file " + file;
                        toDownloadSegmentNames.add(file);
                    }
                    indexShard.getFileDownloader().download(this.remoteDirectory, storeDirectory, toDownloadSegmentNames);
                    logger.debug("Downloaded segment files from remote store {}", filesToFetch);
                }
                finally {
                    indexShard.store().decRef();
                    indexShard.remoteStore().decRef();
                }
            }
            listener.onResponse(new GetSegmentFilesResponse(filesToFetch));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public String getDescription() {
        return "RemoteStoreReplicationSource";
    }
}

