/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.ReplicationTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeases;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.ForceSyncRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryCleanFilesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryFilesInfoRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RetryableTransportClient;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.RemoteSegmentFileChunkWriter;
import org.graylog.shaded.opensearch2.org.opensearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private static final Logger logger = LogManager.getLogger(RemoteRecoveryTargetHandler.class);
    private final TransportService transportService;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final TransportRequestOptions translogOpsRequestOptions;
    private final AtomicLong requestSeqNoGenerator = new AtomicLong(0L);
    private final RetryableTransportClient retryableTransportClient;
    private final RemoteSegmentFileChunkWriter fileChunkWriter;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.retryableTransportClient = new RetryableTransportClient(transportService, targetNode, recoverySettings.internalActionRetryTimeout(), logger);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkWriter = new RemoteSegmentFileChunkWriter(recoveryId, recoverySettings, this.retryableTransportClient, shardId, "internal:index/shard/recovery/file_chunk", this.requestSeqNoGenerator, onSourceThrottle);
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/prepare_translog";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryPrepareForTranslogOperationsRequest request = new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, totalTranslogOps);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, responseListener, reader);
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/finalize";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFinalizeRecoveryRequest request = new RecoveryFinalizeRecoveryRequest(this.recoveryId, requestSeqNo, this.shardId, globalCheckpoint, trimAboveSeqNo);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/finalize", request, responseListener, reader);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        String action = "internal:index/shard/recovery/translog_ops";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        Writeable.Reader<RecoveryTranslogOperationsResponse> reader = RecoveryTranslogOperationsResponse::new;
        ActionListener<RecoveryTranslogOperationsResponse> responseListener = ActionListener.map(listener, r -> r.localCheckpoint);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, responseListener, reader);
    }

    @Override
    public void forceSegmentFileSync() {
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/replication/segments_sync", new ForceSyncRequest(requestSeqNo, this.recoveryId, this.shardId), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/filesInfo";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFilesInfoRequest request = new RecoveryFilesInfoRequest(this.recoveryId, requestSeqNo, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/filesInfo", request, responseListener, reader);
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/clean_files";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryCleanFilesRequest request = new RecoveryCleanFilesRequest(this.recoveryId, requestSeqNo, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.retryableTransportClient.executeRetryableAction("internal:index/shard/recovery/clean_files", request, responseListener, reader);
    }

    @Override
    public void cancel() {
        this.retryableTransportClient.cancel();
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        this.fileChunkWriter.writeFileChunk(fileMetadata, position, content, lastChunk, totalTranslogOps, listener);
    }
}

