/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public class ReestablishRecoveryRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final String targetAllocationId;

    public ReestablishRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.targetAllocationId = in.readString();
    }

    public ReestablishRecoveryRequest(long recoveryId, ShardId shardId, String targetAllocationId) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.targetAllocationId);
    }
}

