/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.nio.file.Path;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;

public final class TranslogConfig {
    public static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(1L, ByteSizeUnit.MB);
    public static final ByteSizeValue EMPTY_TRANSLOG_BUFFER_SIZE = new ByteSizeValue(10L, ByteSizeUnit.BYTES);
    private final BigArrays bigArrays;
    private final IndexSettings indexSettings;
    private final ShardId shardId;
    private final Path translogPath;
    private final ByteSizeValue bufferSize;
    private final String nodeId;

    public TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, String nodeId) {
        this(shardId, translogPath, indexSettings, bigArrays, DEFAULT_BUFFER_SIZE, nodeId);
    }

    TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, ByteSizeValue bufferSize, String nodeId) {
        this.bufferSize = bufferSize;
        this.indexSettings = indexSettings;
        this.shardId = shardId;
        this.translogPath = translogPath;
        this.bigArrays = bigArrays;
        this.nodeId = nodeId;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public Path getTranslogPath() {
        return this.translogPath;
    }

    public ByteSizeValue getBufferSize() {
        return this.bufferSize;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

