/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ReleasableLock;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.util.FileSystemUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.BaseTranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Checkpoint;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.FileTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TransferSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogCheckpointTransferSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.listener.TranslogTransferListener;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteFsTranslog
extends Translog {
    private final Logger logger;
    private final BlobStoreRepository blobStoreRepository;
    private final TranslogTransferManager translogTransferManager;
    private final FileTransferTracker fileTransferTracker;
    private final BooleanSupplier primaryModeSupplier;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;
    private volatile long maxRemoteTranslogGenerationUploaded;
    private volatile long minSeqNoToKeep;
    private volatile long minRemoteGenReferenced;
    private final SetOnce<Boolean> olderPrimaryCleaned = new SetOnce();
    private static final int REMOTE_DELETION_PERMITS = 2;
    private static final int DOWNLOAD_RETRIES = 2;
    public static final String TRANSLOG = "translog";
    private final Semaphore remoteGenerationDeletionPermits = new Semaphore(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFsTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BlobStoreRepository blobStoreRepository, ThreadPool threadPool, BooleanSupplier primaryModeSupplier, RemoteTranslogTransferTracker remoteTranslogTransferTracker) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer);
        this.logger = Loggers.getLogger(this.getClass(), this.shardId, new String[0]);
        this.blobStoreRepository = blobStoreRepository;
        this.primaryModeSupplier = primaryModeSupplier;
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
        this.fileTransferTracker = new FileTransferTracker(this.shardId, remoteTranslogTransferTracker);
        this.translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, this.shardId, this.fileTransferTracker, remoteTranslogTransferTracker);
        try {
            RemoteFsTranslog.download(this.translogTransferManager, this.location, this.logger);
            Checkpoint checkpoint = RemoteFsTranslog.readCheckpoint(this.location);
            this.readers.addAll(this.recoverFromFiles(checkpoint));
            if (this.readers.isEmpty()) {
                String errorMsg = String.format(Locale.ROOT, "%s at least one reader must be recovered", this.shardId);
                this.logger.error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            boolean success = false;
            this.current = null;
            try {
                this.current = this.createWriter(checkpoint.generation + 1L, this.getMinFileGeneration(), checkpoint.globalCheckpoint, persistedSequenceNumberConsumer);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.readers);
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable)this.current);
            IOUtils.closeWhileHandlingException(this.readers);
            throw e;
        }
    }

    RemoteTranslogTransferTracker getRemoteTranslogTracker() {
        return this.remoteTranslogTransferTracker;
    }

    public static void download(Repository repository, ShardId shardId, ThreadPool threadPool, Path location, Logger logger) throws IOException {
        assert (repository instanceof BlobStoreRepository) : String.format(Locale.ROOT, "%s repository should be instance of BlobStoreRepository", shardId);
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker);
        RemoteFsTranslog.download(translogTransferManager, location, logger);
    }

    static void download(TranslogTransferManager translogTransferManager, Path location, Logger logger) throws IOException {
        IOException ex = null;
        for (int i = 0; i <= 2; ++i) {
            try {
                RemoteFsTranslog.downloadOnce(translogTransferManager, location, logger);
                return;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                ex = e;
                continue;
            }
        }
        logger.debug("Exhausted all download retries during translog/checkpoint file download");
        throw ex;
    }

    private static void downloadOnce(TranslogTransferManager translogTransferManager, Path location, Logger logger) throws IOException {
        logger.debug("Downloading translog files from remote");
        RemoteTranslogTransferTracker statsTracker = translogTransferManager.getRemoteTranslogTransferTracker();
        long prevDownloadBytesSucceeded = statsTracker.getDownloadBytesSucceeded();
        long prevDownloadTimeInMillis = statsTracker.getTotalDownloadTimeInMillis();
        TranslogTransferMetadata translogMetadata = translogTransferManager.readMetadata();
        if (translogMetadata != null) {
            if (Files.notExists(location, new LinkOption[0])) {
                Files.createDirectories(location, new FileAttribute[0]);
            }
            for (Path file : FileSystemUtils.files(location)) {
                Files.delete(file);
            }
            Map<String, String> generationToPrimaryTermMapper = translogMetadata.getGenerationToPrimaryTermMapper();
            for (long i = translogMetadata.getGeneration(); i >= translogMetadata.getMinTranslogGeneration(); --i) {
                String generation = Long.toString(i);
                translogTransferManager.downloadTranslog(generationToPrimaryTermMapper.get(generation), generation, location);
            }
            logger.info("Downloaded translog and checkpoint files from={} to={}", (Object)translogMetadata.getMinTranslogGeneration(), (Object)translogMetadata.getGeneration());
            statsTracker.recordDownloadStats(prevDownloadBytesSucceeded, prevDownloadTimeInMillis);
            Files.copy(location.resolve(Translog.getCommitCheckpointFileName(translogMetadata.getGeneration())), location.resolve("translog.ckp"), new CopyOption[0]);
        }
        logger.debug("downloadOnce execution completed");
    }

    public static TranslogTransferManager buildTranslogTransferManager(BlobStoreRepository blobStoreRepository, ThreadPool threadPool, ShardId shardId, FileTransferTracker fileTransferTracker, RemoteTranslogTransferTracker remoteTranslogTransferTracker) {
        return new TranslogTransferManager(shardId, new BlobStoreTransferService(blobStoreRepository.blobStore(), threadPool), blobStoreRepository.basePath().add(shardId.getIndex().getUUID()).add(String.valueOf(shardId.id())).add(TRANSLOG), fileTransferTracker, remoteTranslogTransferTracker);
    }

    @Override
    public boolean ensureSynced(Translog.Location location) throws IOException {
        assert (location.generation <= this.current.getGeneration());
        if (location.generation == this.current.getGeneration()) {
            this.ensureOpen();
            return this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), location.generation);
        }
        return false;
    }

    @Override
    public void rollGeneration() throws IOException {
        this.syncBeforeRollGeneration();
        if (this.current.totalOperations() == 0 && this.primaryTermSupplier.getAsLong() == this.current.getPrimaryTerm()) {
            return;
        }
        this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
    }

    private boolean prepareAndUpload(Long primaryTerm, Long generation) throws IOException {
        ReleasableLock ignored;
        block32: {
            ignored = this.writeLock.acquire();
            try {
                if (generation == null || generation.longValue() == this.current.getGeneration()) {
                    try {
                        TranslogReader reader = this.current.closeIntoReader();
                        this.readers.add(reader);
                        this.copyCheckpointTo(this.location.resolve(RemoteFsTranslog.getCommitCheckpointFileName(this.current.getGeneration())));
                        if (!this.closed.get()) {
                            this.logger.trace("Creating new writer for gen: [{}]", (Object)(this.current.getGeneration() + 1L));
                            this.current = this.createWriter(this.current.getGeneration() + 1L);
                        }
                        assert (this.writeLock.isHeldByCurrentThread()) : "Write lock must be held before we acquire the read lock";
                        this.readLock.acquire();
                        break block32;
                    }
                    catch (Exception e) {
                        this.tragedy.setTragicException(e);
                        this.closeOnTragicEvent(e);
                        throw e;
                    }
                }
                if (generation < this.current.getGeneration()) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        assert (this.readLock.isHeldByCurrentThread());
        ignored = this.readLock;
        try {
            Releasable ignoredGenLock;
            block33: {
                block34: {
                    ignoredGenLock = this.deletionPolicy.acquireTranslogGen(this.getMinFileGeneration());
                    try {
                        if (generation != null) break block33;
                        if (this.closed.get()) break block34;
                        boolean bl = this.upload(primaryTerm, this.current.getGeneration() - 1L);
                        if (ignoredGenLock != null) {
                            ignoredGenLock.close();
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (ignoredGenLock != null) {
                            try {
                                ignoredGenLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                boolean bl = this.upload(primaryTerm, this.current.getGeneration());
                if (ignoredGenLock != null) {
                    ignoredGenLock.close();
                }
                return bl;
            }
            boolean bl = this.upload(primaryTerm, generation);
            if (ignoredGenLock != null) {
                ignoredGenLock.close();
            }
            return bl;
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private boolean upload(Long primaryTerm, Long generation) throws IOException {
        if (!this.primaryModeSupplier.getAsBoolean()) {
            this.logger.debug("skipped uploading translog for {} {}", (Object)primaryTerm, (Object)generation);
            return true;
        }
        this.logger.trace("uploading translog for {} {}", (Object)primaryTerm, (Object)generation);
        try (TranslogCheckpointTransferSnapshot transferSnapshotProvider = new TranslogCheckpointTransferSnapshot.Builder(primaryTerm, generation, this.location, this.readers, Translog::getCommitCheckpointFileName, this.config.getNodeId()).build();){
            boolean bl = this.translogTransferManager.transferSnapshot(transferSnapshotProvider, new RemoteFsTranslogTransferListener(generation, primaryTerm));
            return bl;
        }
    }

    public Set<String> allUploaded() {
        return this.fileTransferTracker.allUploaded();
    }

    private boolean syncToDisk() throws IOException {
        ReleasableLock lock = this.readLock.acquire();
        try {
            boolean bl = this.current.sync();
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.closeOnTragicEvent(ex);
                throw ex;
            }
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.syncToDisk() || this.syncNeeded()) {
            this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
        }
    }

    @Override
    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded() || this.maxRemoteTranslogGenerationUploaded + 1L < this.currentFileGeneration() && this.current.totalOperations() == 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        assert (Translog.calledFromOutsideOrViaTragedyClose()) : this.shardId + "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.sync();
            }
            finally {
                this.logger.debug("translog closed");
                this.closeFilesIfNoPendingRetentionLocks();
            }
        }
    }

    @Override
    protected long getMinReferencedGen() throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        long minReferencedGen = Math.min(this.deletionPolicy.minTranslogGenRequired(this.readers, this.current), RemoteFsTranslog.minGenerationForSeqNo(this.minSeqNoToKeep, this.current, this.readers));
        assert (minReferencedGen >= this.getMinFileGeneration()) : this.shardId + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
        assert (minReferencedGen <= this.currentFileGeneration()) : this.shardId + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
        return minReferencedGen;
    }

    @Override
    protected void setMinSeqNoToKeep(long seqNo) {
        if (seqNo < this.minSeqNoToKeep) {
            throw new IllegalArgumentException(this.shardId + " min seq number required can't go backwards: current [" + this.minSeqNoToKeep + "] new [" + seqNo + "]");
        }
        this.minSeqNoToKeep = seqNo;
    }

    @Override
    public void trimUnreferencedReaders() throws IOException {
        super.trimUnreferencedReaders();
        if (!this.remoteGenerationDeletionPermits.tryAcquire(2)) {
            return;
        }
        HashSet<Long> generationsToDelete = new HashSet<Long>();
        for (long generation = this.minRemoteGenReferenced - 1L; generation >= 0L && this.fileTransferTracker.uploaded(Translog.getFilename(generation)); --generation) {
            generationsToDelete.add(generation);
        }
        if (!generationsToDelete.isEmpty()) {
            this.deleteRemoteGeneration(generationsToDelete);
            this.translogTransferManager.deleteStaleTranslogMetadataFilesAsync(this.remoteGenerationDeletionPermits::release);
            this.deleteStaleRemotePrimaryTerms();
        } else {
            this.remoteGenerationDeletionPermits.release(2);
        }
    }

    private void deleteRemoteGeneration(Set<Long> generations) {
        this.translogTransferManager.deleteGenerationAsync(this.primaryTermSupplier.getAsLong(), generations, this.remoteGenerationDeletionPermits::release);
    }

    private void deleteStaleRemotePrimaryTerms() {
        if (this.olderPrimaryCleaned.trySet(Boolean.TRUE)) {
            if (this.readers.isEmpty()) {
                this.logger.trace("Translog reader list is empty, returning from deleteStaleRemotePrimaryTerms");
                return;
            }
            long minimumReferencedPrimaryTerm = this.readers.stream().map(BaseTranslogReader::getPrimaryTerm).min(Long::compare).get();
            this.translogTransferManager.deletePrimaryTermsAsync(minimumReferencedPrimaryTerm);
        }
    }

    public static void cleanup(Repository repository, ShardId shardId, ThreadPool threadPool) throws IOException {
        assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker);
        translogTransferManager.deleteTranslogFiles();
    }

    @Override
    protected void onDelete() {
        if (!this.primaryModeSupplier.getAsBoolean()) {
            this.logger.trace("skipped delete translog");
            return;
        }
        this.translogTransferManager.delete();
    }

    boolean isRemoteGenerationDeletionPermitsAvailable() {
        return this.remoteGenerationDeletionPermits.availablePermits() == 2;
    }

    private class RemoteFsTranslogTransferListener
    implements TranslogTransferListener {
        private final Long generation;
        private final Long primaryTerm;

        RemoteFsTranslogTransferListener(Long generation, Long primaryTerm) {
            this.generation = generation;
            this.primaryTerm = primaryTerm;
        }

        @Override
        public void onUploadComplete(TransferSnapshot transferSnapshot) throws IOException {
            RemoteFsTranslog.this.maxRemoteTranslogGenerationUploaded = this.generation;
            RemoteFsTranslog.this.minRemoteGenReferenced = RemoteFsTranslog.this.getMinFileGeneration();
            RemoteFsTranslog.this.logger.trace("uploaded translog for {} {} ", (Object)this.primaryTerm, (Object)this.generation);
        }

        @Override
        public void onUploadFailed(TransferSnapshot transferSnapshot, Exception ex) throws IOException {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
    }
}

