/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.BufferedChecksum;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

public final class BufferedChecksumStreamOutput
extends StreamOutput {
    private final StreamOutput out;
    private final Checksum digest;

    public BufferedChecksumStreamOutput(StreamOutput out) {
        this.out = out;
        this.digest = new BufferedChecksum(new CRC32());
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
        this.digest.update(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.out.writeBytes(b, offset, length);
        this.digest.update(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void reset() throws IOException {
        this.out.reset();
        this.digest.reset();
    }

    public void resetDigest() {
        this.digest.reset();
    }
}

