/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.GroupedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.PlainActionFuture;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.UncategorizedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

@InternalApi
public final class RemoteStoreFileDownloader {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final RecoverySettings recoverySettings;

    public RemoteStoreFileDownloader(ShardId shardId, ThreadPool threadPool, RecoverySettings recoverySettings) {
        this.logger = Loggers.getLogger(RemoteStoreFileDownloader.class, shardId, new String[0]);
        this.threadPool = threadPool;
        this.recoverySettings = recoverySettings;
    }

    public void download(Directory source, Directory destination, Collection<String> toDownloadSegments) throws IOException {
        this.downloadInternal(source, destination, null, toDownloadSegments, () -> {});
    }

    public void download(Directory source, Directory destination, Directory secondDestination, Collection<String> toDownloadSegments, Runnable onFileCompletion) throws IOException {
        this.downloadInternal(source, destination, secondDestination, toDownloadSegments, onFileCompletion);
    }

    private void downloadInternal(Directory source, Directory destination, @Nullable Directory secondDestination, Collection<String> toDownloadSegments, Runnable onFileCompletion) throws IOException {
        ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>(toDownloadSegments);
        int threads = Math.min(toDownloadSegments.size(), Math.min(this.threadPool.info("remote_recovery").getMax(), this.recoverySettings.getMaxConcurrentRemoteStoreStreams()));
        this.logger.trace("Starting download of {} files with {} threads", (Object)queue.size(), (Object)threads);
        PlainActionFuture listener = PlainActionFuture.newFuture();
        GroupedActionListener<Void> allFilesListener = new GroupedActionListener<Void>(listener, threads);
        for (int i = 0; i < threads; ++i) {
            this.copyOneFile(source, destination, secondDestination, queue, onFileCompletion, allFilesListener);
        }
        try {
            listener.actionGet();
        }
        catch (UncategorizedExecutionException e) {
            if (e.getCause() instanceof ExecutionException && e.getCause().getCause() instanceof IOException) {
                throw (IOException)e.getCause().getCause();
            }
            throw e;
        }
    }

    private void copyOneFile(Directory source, Directory destination, @Nullable Directory secondDestination, Queue<String> queue, Runnable onFileCompletion, ActionListener<Void> listener) {
        String file = queue.poll();
        if (file == null) {
            listener.onResponse(null);
        } else {
            this.threadPool.executor("remote_recovery").submit(() -> {
                this.logger.trace("Downloading file {}", (Object)file);
                try {
                    destination.copyFrom(source, file, file, IOContext.DEFAULT);
                    onFileCompletion.run();
                    if (secondDestination != null) {
                        secondDestination.copyFrom(destination, file, file, IOContext.DEFAULT);
                    }
                }
                catch (Exception e) {
                    queue.clear();
                    listener.onFailure(e);
                    return;
                }
                this.copyOneFile(source, destination, secondDestination, queue, onFileCompletion, listener);
            });
        }
    }
}

