/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreLockManagerFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.IndexStorePlugin;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteSegmentStoreDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private static final String SEGMENTS = "segments";
    private final Supplier<RepositoriesService> repositoriesService;
    private final ThreadPool threadPool;

    public RemoteSegmentStoreDirectoryFactory(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool) {
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        String repositoryName = indexSettings.getRemoteStoreRepository();
        String indexUUID = indexSettings.getIndex().getUUID();
        return this.newDirectory(repositoryName, indexUUID, path.getShardId());
    }

    public Directory newDirectory(String repositoryName, String indexUUID, ShardId shardId) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory;
        block9: {
            Repository repository = this.repositoriesService.get().repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
                BlobPath commonBlobPath = blobStoreRepository.basePath();
                commonBlobPath = commonBlobPath.add(indexUUID).add(String.valueOf(shardId.id())).add(SEGMENTS);
                RemoteDirectory dataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(commonBlobPath.add("data")), blobStoreRepository::maybeRateLimitRemoteUploadTransfers, blobStoreRepository::maybeRateLimitRemoteDownloadTransfers);
                RemoteDirectory metadataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(commonBlobPath.add("metadata")));
                RemoteStoreMetadataLockManager mdLockManager = RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, String.valueOf(shardId.id()));
                remoteSegmentStoreDirectory = new RemoteSegmentStoreDirectory(dataDirectory, metadataDirectory, mdLockManager, this.threadPool, shardId);
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", e);
                }
            }
            repository.close();
        }
        return remoteSegmentStoreDirectory;
    }
}

