/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.MovingAverage;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

public class DirectoryFileTransferTracker {
    private final AtomicLong transferredBytesStarted = new AtomicLong();
    private final AtomicLong transferredBytesFailed = new AtomicLong();
    private final AtomicLong transferredBytesSucceeded = new AtomicLong();
    private final AtomicLong lastTransferTimestampMs = new AtomicLong();
    private final AtomicLong totalTransferTimeInMs = new AtomicLong();
    private final AtomicReference<MovingAverage> transferredBytesMovingAverageReference;
    private final AtomicLong lastSuccessfulTransferInBytes = new AtomicLong();
    private final AtomicReference<MovingAverage> transferredBytesPerSecMovingAverageReference;
    private final int DIRECTORY_FILES_TRANSFER_DEFAULT_WINDOW_SIZE = 20;

    public long getTransferredBytesStarted() {
        return this.transferredBytesStarted.get();
    }

    public void addTransferredBytesStarted(long size) {
        this.transferredBytesStarted.getAndAdd(size);
    }

    public long getTransferredBytesFailed() {
        return this.transferredBytesFailed.get();
    }

    public void addTransferredBytesFailed(long size, long startTimeInMs) {
        this.transferredBytesFailed.getAndAdd(size);
        this.addTotalTransferTimeInMs(Math.max(1L, System.currentTimeMillis() - startTimeInMs));
    }

    public long getTransferredBytesSucceeded() {
        return this.transferredBytesSucceeded.get();
    }

    public void addTransferredBytesSucceeded(long size, long startTimeInMs) {
        this.transferredBytesSucceeded.getAndAdd(size);
        this.updateSuccessfulTransferSize(size);
        long currentTimeInMs = System.currentTimeMillis();
        this.updateLastTransferTimestampMs(currentTimeInMs);
        long timeTakenInMS = Math.max(1L, currentTimeInMs - startTimeInMs);
        this.addTotalTransferTimeInMs(timeTakenInMS);
        this.addTransferredBytesPerSec(size * 1000L / timeTakenInMS);
    }

    public boolean isTransferredBytesPerSecAverageReady() {
        return this.transferredBytesPerSecMovingAverageReference.get().isReady();
    }

    public double getTransferredBytesPerSecAverage() {
        return this.transferredBytesPerSecMovingAverageReference.get().getAverage();
    }

    public void addTransferredBytesPerSec(long bytesPerSec) {
        this.transferredBytesPerSecMovingAverageReference.get().record(bytesPerSec);
    }

    public boolean isTransferredBytesAverageReady() {
        return this.transferredBytesMovingAverageReference.get().isReady();
    }

    public double getTransferredBytesAverage() {
        return this.transferredBytesMovingAverageReference.get().getAverage();
    }

    public void updateLastSuccessfulTransferInBytes(long size) {
        this.lastSuccessfulTransferInBytes.set(size);
    }

    public void updateSuccessfulTransferSize(long size) {
        this.updateLastSuccessfulTransferInBytes(size);
        this.transferredBytesMovingAverageReference.get().record(size);
    }

    public long getLastTransferTimestampMs() {
        return this.lastTransferTimestampMs.get();
    }

    public void updateLastTransferTimestampMs(long downloadTimestampInMs) {
        this.lastTransferTimestampMs.set(downloadTimestampInMs);
    }

    public void addTotalTransferTimeInMs(long totalTransferTimeInMs) {
        this.totalTransferTimeInMs.addAndGet(totalTransferTimeInMs);
    }

    public long getTotalTransferTimeInMs() {
        return this.totalTransferTimeInMs.get();
    }

    public DirectoryFileTransferTracker() {
        this.transferredBytesMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(20));
        this.transferredBytesPerSecMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(20));
    }

    public Stats stats() {
        return new Stats(this.transferredBytesStarted.get(), this.transferredBytesFailed.get(), this.transferredBytesSucceeded.get(), this.lastTransferTimestampMs.get(), this.totalTransferTimeInMs.get(), this.transferredBytesMovingAverageReference.get().getAverage(), this.lastSuccessfulTransferInBytes.get(), this.transferredBytesPerSecMovingAverageReference.get().getAverage());
    }

    public static class Stats
    implements Writeable {
        public final long transferredBytesStarted;
        public final long transferredBytesFailed;
        public final long transferredBytesSucceeded;
        public final long lastTransferTimestampMs;
        public final long totalTransferTimeInMs;
        public final double transferredBytesMovingAverage;
        public final long lastSuccessfulTransferInBytes;
        public final double transferredBytesPerSecMovingAverage;

        public Stats(long transferredBytesStarted, long transferredBytesFailed, long downloadBytesSucceeded, long lastTransferTimestampMs, long totalTransferTimeInMs, double transferredBytesMovingAverage, long lastSuccessfulTransferInBytes, double transferredBytesPerSecMovingAverage) {
            this.transferredBytesStarted = transferredBytesStarted;
            this.transferredBytesFailed = transferredBytesFailed;
            this.transferredBytesSucceeded = downloadBytesSucceeded;
            this.lastTransferTimestampMs = lastTransferTimestampMs;
            this.totalTransferTimeInMs = totalTransferTimeInMs;
            this.transferredBytesMovingAverage = transferredBytesMovingAverage;
            this.lastSuccessfulTransferInBytes = lastSuccessfulTransferInBytes;
            this.transferredBytesPerSecMovingAverage = transferredBytesPerSecMovingAverage;
        }

        public Stats(StreamInput in) throws IOException {
            this.transferredBytesStarted = in.readLong();
            this.transferredBytesFailed = in.readLong();
            this.transferredBytesSucceeded = in.readLong();
            this.lastTransferTimestampMs = in.readLong();
            this.totalTransferTimeInMs = in.readLong();
            this.transferredBytesMovingAverage = in.readDouble();
            this.lastSuccessfulTransferInBytes = in.readLong();
            this.transferredBytesPerSecMovingAverage = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.transferredBytesStarted);
            out.writeLong(this.transferredBytesFailed);
            out.writeLong(this.transferredBytesSucceeded);
            out.writeLong(this.lastTransferTimestampMs);
            out.writeLong(this.totalTransferTimeInMs);
            out.writeDouble(this.transferredBytesMovingAverage);
            out.writeLong(this.lastSuccessfulTransferInBytes);
            out.writeDouble(this.transferredBytesPerSecMovingAverage);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Stats stats = (Stats)obj;
            return this.transferredBytesStarted == stats.transferredBytesStarted && this.transferredBytesFailed == stats.transferredBytesFailed && this.transferredBytesSucceeded == stats.transferredBytesSucceeded && this.lastTransferTimestampMs == stats.lastTransferTimestampMs && this.totalTransferTimeInMs == stats.totalTransferTimeInMs && Double.compare(stats.transferredBytesMovingAverage, this.transferredBytesMovingAverage) == 0 && this.lastSuccessfulTransferInBytes == stats.lastSuccessfulTransferInBytes && Double.compare(stats.transferredBytesPerSecMovingAverage, this.transferredBytesPerSecMovingAverage) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.transferredBytesStarted, this.transferredBytesFailed, this.transferredBytesSucceeded, this.lastTransferTimestampMs, this.totalTransferTimeInMs, this.transferredBytesMovingAverage, this.lastSuccessfulTransferInBytes, this.transferredBytesPerSecMovingAverage);
        }
    }
}

