/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore.SnapshotFiles;

public class BlobStoreIndexShardSnapshots
implements Iterable<SnapshotFiles>,
ToXContentFragment {
    public static final BlobStoreIndexShardSnapshots EMPTY = new BlobStoreIndexShardSnapshots(Collections.emptyList());
    private final List<SnapshotFiles> shardSnapshots;
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> files;
    private final Map<String, List<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles;

    public BlobStoreIndexShardSnapshots(List<SnapshotFiles> shardSnapshots) {
        this.shardSnapshots = Collections.unmodifiableList(new ArrayList<SnapshotFiles>(shardSnapshots));
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> newFiles = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        HashMap<String, ArrayList<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles = new HashMap<String, ArrayList<BlobStoreIndexShardSnapshot.FileInfo>>();
        for (SnapshotFiles snapshot : shardSnapshots) {
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                BlobStoreIndexShardSnapshot.FileInfo oldFile = newFiles.put(fileInfo.name(), fileInfo);
                assert (oldFile == null || oldFile.isSame(fileInfo));
            }
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> physicalFileList = (ArrayList<BlobStoreIndexShardSnapshot.FileInfo>)physicalFiles.get(fileInfo.physicalName());
                if (physicalFileList == null) {
                    physicalFileList = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                    physicalFiles.put(fileInfo.physicalName(), physicalFileList);
                }
                physicalFileList.add((BlobStoreIndexShardSnapshot.FileInfo)newFiles.get(fileInfo.name()));
            }
        }
        HashMap mapBuilder = new HashMap();
        for (Map.Entry entry : physicalFiles.entrySet()) {
            mapBuilder.put((String)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        this.physicalFiles = Collections.unmodifiableMap(mapBuilder);
        this.files = Collections.unmodifiableMap(newFiles);
    }

    private BlobStoreIndexShardSnapshots(Map<String, BlobStoreIndexShardSnapshot.FileInfo> files, List<SnapshotFiles> shardSnapshots) {
        this.shardSnapshots = shardSnapshots;
        this.files = files;
        HashMap<String, ArrayList<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles = new HashMap<String, ArrayList<BlobStoreIndexShardSnapshot.FileInfo>>();
        for (SnapshotFiles snapshot : shardSnapshots) {
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> physicalFileList = (ArrayList<BlobStoreIndexShardSnapshot.FileInfo>)physicalFiles.get(fileInfo.physicalName());
                if (physicalFileList == null) {
                    physicalFileList = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                    physicalFiles.put(fileInfo.physicalName(), physicalFileList);
                }
                physicalFileList.add(files.get(fileInfo.name()));
            }
        }
        HashMap mapBuilder = new HashMap();
        for (Map.Entry entry : physicalFiles.entrySet()) {
            mapBuilder.put((String)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        this.physicalFiles = Collections.unmodifiableMap(mapBuilder);
    }

    public BlobStoreIndexShardSnapshots withClone(String source, String target) {
        SnapshotFiles sourceFiles = null;
        for (SnapshotFiles shardSnapshot : this.shardSnapshots) {
            if (!shardSnapshot.snapshot().equals(source)) continue;
            sourceFiles = shardSnapshot;
            break;
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException("unknown source [" + source + "]");
        }
        ArrayList<SnapshotFiles> updated = new ArrayList<SnapshotFiles>(this.shardSnapshots);
        updated.add(sourceFiles.withSnapshotName(target));
        return new BlobStoreIndexShardSnapshots(updated);
    }

    public List<SnapshotFiles> snapshots() {
        return this.shardSnapshots;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> findPhysicalIndexFiles(String physicalName) {
        return this.physicalFiles.get(physicalName);
    }

    public BlobStoreIndexShardSnapshot.FileInfo findNameFile(String name) {
        return this.files.get(name);
    }

    @Override
    public Iterator<SnapshotFiles> iterator() {
        return this.shardSnapshots.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("files");
        for (Map.Entry<String, BlobStoreIndexShardSnapshot.FileInfo> entry : this.files.entrySet()) {
            BlobStoreIndexShardSnapshot.FileInfo.toXContent(entry.getValue(), builder, params);
        }
        builder.endArray();
        builder.startObject("snapshots");
        for (SnapshotFiles snapshot : this.shardSnapshots) {
            builder.startObject(snapshot.snapshot());
            builder.startArray("files");
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                builder.value(fileInfo.name());
            }
            builder.endArray();
            if (snapshot.shardStateIdentifier() != null) {
                builder.field(ParseFields.SHARD_STATE_ID.getPreferredName(), snapshot.shardStateIdentifier());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static BlobStoreIndexShardSnapshots fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        HashMap snapshotsMap = new HashMap();
        HashMap<String, String> historyUUIDs = new HashMap<String, String>();
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                String currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!ParseFields.FILES.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new OpenSearchParseException("unknown array [{}]", currentFieldName);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        BlobStoreIndexShardSnapshot.FileInfo fileInfo = BlobStoreIndexShardSnapshot.FileInfo.fromXContent(parser);
                        files.put(fileInfo.name(), fileInfo);
                    }
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!ParseFields.SNAPSHOTS.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new OpenSearchParseException("unknown object [{}]", currentFieldName);
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                        String snapshot = parser.currentName();
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token != XContentParser.Token.FIELD_NAME) continue;
                            currentFieldName = parser.currentName();
                            if (ParseFields.FILES.match(currentFieldName, parser.getDeprecationHandler()) && parser.nextToken() == XContentParser.Token.START_ARRAY) {
                                ArrayList<String> fileNames = new ArrayList<String>();
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    fileNames.add(parser.text());
                                }
                                snapshotsMap.put(snapshot, fileNames);
                                continue;
                            }
                            if (!ParseFields.SHARD_STATE_ID.match(currentFieldName, parser.getDeprecationHandler())) continue;
                            parser.nextToken();
                            historyUUIDs.put(snapshot, parser.text());
                        }
                    }
                    continue;
                }
                throw new OpenSearchParseException("unexpected token [{}]", new Object[]{token});
            }
        }
        ArrayList<SnapshotFiles> snapshots = new ArrayList<SnapshotFiles>(snapshotsMap.size());
        for (Map.Entry entry : snapshotsMap.entrySet()) {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfosBuilder = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (String file : (List)entry.getValue()) {
                BlobStoreIndexShardSnapshot.FileInfo fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)files.get(file);
                assert (fileInfo != null);
                fileInfosBuilder.add(fileInfo);
            }
            snapshots.add(new SnapshotFiles((String)entry.getKey(), Collections.unmodifiableList(fileInfosBuilder), (String)historyUUIDs.get(entry.getKey())));
        }
        return new BlobStoreIndexShardSnapshots(files, Collections.unmodifiableList(snapshots));
    }

    static final class Fields {
        static final String FILES = "files";
        static final String SNAPSHOTS = "snapshots";

        Fields() {
        }
    }

    static final class ParseFields {
        static final ParseField FILES = new ParseField("files", new String[0]);
        static final ParseField SHARD_STATE_ID = new ParseField("shard_state_id", new String[0]);
        static final ParseField SNAPSHOTS = new ParseField("snapshots", new String[0]);

        ParseFields() {
        }
    }
}

