/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class IndexingStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;

    public IndexingStats() {
        this.totalStats = new Stats();
    }

    public IndexingStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        if (in.getVersion().before(Version.V_2_0_0) && in.readBoolean()) {
            Map<String, Stats> typeStats = in.readMap(StreamInput::readString, Stats::new);
            assert (typeStats.size() == 1);
            assert (typeStats.containsKey("_doc"));
        }
    }

    public IndexingStats(Stats totalStats) {
        this.totalStats = totalStats;
    }

    public void add(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.addTotals(indexingStats);
    }

    public void addTotals(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.totalStats.add(indexingStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeBoolean(false);
        }
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private long indexCount;
        private long indexTimeInMillis;
        private long indexCurrent;
        private long indexFailedCount;
        private long deleteCount;
        private long deleteTimeInMillis;
        private long deleteCurrent;
        private long noopUpdateCount;
        private long throttleTimeInMillis;
        private boolean isThrottled;
        private final DocStatusStats docStatusStats;

        Stats() {
            this.docStatusStats = new DocStatusStats();
        }

        public Stats(StreamInput in) throws IOException {
            this.indexCount = in.readVLong();
            this.indexTimeInMillis = in.readVLong();
            this.indexCurrent = in.readVLong();
            this.indexFailedCount = in.readVLong();
            this.deleteCount = in.readVLong();
            this.deleteTimeInMillis = in.readVLong();
            this.deleteCurrent = in.readVLong();
            this.noopUpdateCount = in.readVLong();
            this.isThrottled = in.readBoolean();
            this.throttleTimeInMillis = in.readLong();
            this.docStatusStats = in.getVersion().onOrAfter(Version.V_2_11_0) ? in.readOptionalWriteable(DocStatusStats::new) : null;
        }

        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long indexFailedCount, long deleteCount, long deleteTimeInMillis, long deleteCurrent, long noopUpdateCount, boolean isThrottled, long throttleTimeInMillis, DocStatusStats docStatusStats) {
            this.indexCount = indexCount;
            this.indexTimeInMillis = indexTimeInMillis;
            this.indexCurrent = indexCurrent;
            this.indexFailedCount = indexFailedCount;
            this.deleteCount = deleteCount;
            this.deleteTimeInMillis = deleteTimeInMillis;
            this.deleteCurrent = deleteCurrent;
            this.noopUpdateCount = noopUpdateCount;
            this.isThrottled = isThrottled;
            this.throttleTimeInMillis = throttleTimeInMillis;
            this.docStatusStats = docStatusStats;
        }

        public void add(Stats stats) {
            this.indexCount += stats.indexCount;
            this.indexTimeInMillis += stats.indexTimeInMillis;
            this.indexCurrent += stats.indexCurrent;
            this.indexFailedCount += stats.indexFailedCount;
            this.deleteCount += stats.deleteCount;
            this.deleteTimeInMillis += stats.deleteTimeInMillis;
            this.deleteCurrent += stats.deleteCurrent;
            this.noopUpdateCount += stats.noopUpdateCount;
            this.throttleTimeInMillis += stats.throttleTimeInMillis;
            this.isThrottled |= stats.isThrottled;
            if (this.getDocStatusStats() != null) {
                this.getDocStatusStats().add(stats.getDocStatusStats());
            }
        }

        public long getIndexCount() {
            return this.indexCount;
        }

        public long getIndexFailedCount() {
            return this.indexFailedCount;
        }

        public TimeValue getIndexTime() {
            return new TimeValue(this.indexTimeInMillis);
        }

        public long getIndexCurrent() {
            return this.indexCurrent;
        }

        public long getDeleteCount() {
            return this.deleteCount;
        }

        public boolean isThrottled() {
            return this.isThrottled;
        }

        public TimeValue getThrottleTime() {
            return new TimeValue(this.throttleTimeInMillis);
        }

        public TimeValue getDeleteTime() {
            return new TimeValue(this.deleteTimeInMillis);
        }

        public long getDeleteCurrent() {
            return this.deleteCurrent;
        }

        public long getNoopUpdateCount() {
            return this.noopUpdateCount;
        }

        public DocStatusStats getDocStatusStats() {
            return this.docStatusStats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indexTimeInMillis);
            out.writeVLong(this.indexCurrent);
            out.writeVLong(this.indexFailedCount);
            out.writeVLong(this.deleteCount);
            out.writeVLong(this.deleteTimeInMillis);
            out.writeVLong(this.deleteCurrent);
            out.writeVLong(this.noopUpdateCount);
            out.writeBoolean(this.isThrottled);
            out.writeLong(this.throttleTimeInMillis);
            if (out.getVersion().onOrAfter(Version.V_2_11_0)) {
                out.writeOptionalWriteable(this.docStatusStats);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("index_total", this.indexCount);
            builder.humanReadableField("index_time_in_millis", "index_time", this.getIndexTime());
            builder.field("index_current", this.indexCurrent);
            builder.field("index_failed", this.indexFailedCount);
            builder.field("delete_total", this.deleteCount);
            builder.humanReadableField("delete_time_in_millis", "delete_time", this.getDeleteTime());
            builder.field("delete_current", this.deleteCurrent);
            builder.field("noop_update_total", this.noopUpdateCount);
            builder.field("is_throttled", this.isThrottled);
            builder.humanReadableField("throttle_time_in_millis", "throttle_time", this.getThrottleTime());
            if (this.getDocStatusStats() != null) {
                this.getDocStatusStats().toXContent(builder, params);
            }
            return builder;
        }

        public static class DocStatusStats
        implements Writeable,
        ToXContentFragment {
            final AtomicLong[] docStatusCounter;

            public DocStatusStats() {
                this.docStatusCounter = new AtomicLong[5];
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    this.docStatusCounter[i] = new AtomicLong(0L);
                }
            }

            public DocStatusStats(StreamInput in) throws IOException {
                this.docStatusCounter = in.readArray(i -> new AtomicLong(i.readLong()), AtomicLong[]::new);
                assert (this.docStatusCounter.length == 5) : "Length of incoming array should be 5! Got " + this.docStatusCounter.length;
            }

            public void inc(RestStatus status) {
                this.add(status, 1L);
            }

            void add(RestStatus status, long delta) {
                this.docStatusCounter[status.getStatusFamilyCode() - 1].addAndGet(delta);
            }

            public void add(DocStatusStats stats) {
                if (null == stats) {
                    return;
                }
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    this.docStatusCounter[i].addAndGet(stats.docStatusCounter[i].longValue());
                }
            }

            public AtomicLong[] getDocStatusCounter() {
                return this.docStatusCounter;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("doc_status");
                for (int i = 0; i < this.docStatusCounter.length; ++i) {
                    long value = this.docStatusCounter[i].longValue();
                    if (value <= 0L) continue;
                    String key = i + 1 + "xx";
                    builder.field(key, value);
                }
                return builder.endObject();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeArray((o, v) -> o.writeLong(v.longValue()), this.docStatusCounter);
            }
        }
    }

    private static final class Fields {
        static final String INDEXING = "indexing";
        static final String INDEX_TOTAL = "index_total";
        static final String INDEX_TIME = "index_time";
        static final String INDEX_TIME_IN_MILLIS = "index_time_in_millis";
        static final String INDEX_CURRENT = "index_current";
        static final String INDEX_FAILED = "index_failed";
        static final String DELETE_TOTAL = "delete_total";
        static final String DELETE_TIME = "delete_time";
        static final String DELETE_TIME_IN_MILLIS = "delete_time_in_millis";
        static final String DELETE_CURRENT = "delete_current";
        static final String NOOP_UPDATE_TOTAL = "noop_update_total";
        static final String IS_THROTTLED = "is_throttled";
        static final String THROTTLED_TIME_IN_MILLIS = "throttle_time_in_millis";
        static final String THROTTLED_TIME = "throttle_time";
        static final String DOC_STATUS = "doc_status";

        private Fields() {
        }
    }
}

