/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.FutureUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.Assertions;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardClosedException;

public class GlobalCheckpointListeners
implements Closeable {
    private boolean closed;
    private final Map<GlobalCheckpointListener, Tuple<Long, ScheduledFuture<?>>> listeners = new LinkedHashMap();
    private long lastKnownGlobalCheckpoint = -2L;
    private final ShardId shardId;
    private final ScheduledExecutorService scheduler;
    private final Logger logger;

    GlobalCheckpointListeners(ShardId shardId, ScheduledExecutorService scheduler, Logger logger) {
        this.shardId = Objects.requireNonNull(shardId, "shardId");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    synchronized void add(long waitingForGlobalCheckpoint, GlobalCheckpointListener listener, TimeValue timeout) {
        if (this.closed) {
            this.notifyListener(listener, -2L, new IndexShardClosedException(this.shardId));
            return;
        }
        if (this.lastKnownGlobalCheckpoint >= waitingForGlobalCheckpoint) {
            this.notifyListener(listener, this.lastKnownGlobalCheckpoint, null);
        } else if (timeout == null) {
            this.listeners.put(listener, Tuple.tuple(waitingForGlobalCheckpoint, null));
        } else {
            this.listeners.put(listener, Tuple.tuple(waitingForGlobalCheckpoint, this.scheduler.schedule(() -> {
                boolean removed;
                GlobalCheckpointListeners globalCheckpointListeners = this;
                synchronized (globalCheckpointListeners) {
                    removed = this.listeners.remove(listener) != null;
                }
                if (removed) {
                    TimeoutException e = new TimeoutException(timeout.getStringRep());
                    this.logger.trace("global checkpoint listener timed out", (Throwable)e);
                    this.notifyListener(listener, -2L, e);
                }
            }, timeout.nanos(), TimeUnit.NANOSECONDS)));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) assert (this.listeners.isEmpty()) : this.listeners;
        this.closed = true;
        this.notifyListeners(-2L, new IndexShardClosedException(this.shardId));
    }

    synchronized int pendingListeners() {
        return this.listeners.size();
    }

    synchronized ScheduledFuture<?> getTimeoutFuture(GlobalCheckpointListener listener) {
        return this.listeners.get(listener).v2();
    }

    synchronized void globalCheckpointUpdated(long globalCheckpoint) {
        assert (globalCheckpoint >= -1L);
        assert (globalCheckpoint > this.lastKnownGlobalCheckpoint) : "updated global checkpoint [" + globalCheckpoint + "] is not more than the last known global checkpoint [" + this.lastKnownGlobalCheckpoint + "]";
        this.lastKnownGlobalCheckpoint = globalCheckpoint;
        this.notifyListeners(globalCheckpoint, null);
    }

    private void notifyListeners(long globalCheckpoint, IndexShardClosedException e) {
        Map<GlobalCheckpointListener, Tuple<Long, ScheduledFuture<Object>>> listenersToNotify;
        assert (Thread.holdsLock(this)) : Thread.currentThread();
        if (this.listeners.isEmpty()) {
            return;
        }
        if (globalCheckpoint != -2L) {
            listenersToNotify = this.listeners.entrySet().stream().filter(entry -> (Long)((Tuple)entry.getValue()).v1() <= globalCheckpoint).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            listenersToNotify.keySet().forEach(this.listeners::remove);
        } else {
            listenersToNotify = new HashMap(this.listeners);
            this.listeners.clear();
        }
        if (!listenersToNotify.isEmpty()) {
            listenersToNotify.forEach((listener, t) -> {
                FutureUtils.cancel((Future)t.v2());
                this.notifyListener((GlobalCheckpointListener)listener, globalCheckpoint, e);
            });
        }
    }

    private void notifyListener(GlobalCheckpointListener listener, long globalCheckpoint, Exception e) {
        this.assertNotification(globalCheckpoint, e);
        listener.executor().execute(() -> {
            try {
                listener.accept(globalCheckpoint, e);
            }
            catch (Exception caught) {
                if (globalCheckpoint != -2L) {
                    this.logger.warn((Message)new ParameterizedMessage("error notifying global checkpoint listener of updated global checkpoint [{}]", (Object)globalCheckpoint), (Throwable)caught);
                }
                if (e instanceof IndexShardClosedException) {
                    this.logger.warn("error notifying global checkpoint listener of closed shard", (Throwable)caught);
                }
                this.logger.warn("error notifying global checkpoint listener of timeout", (Throwable)caught);
            }
        });
    }

    private void assertNotification(long globalCheckpoint, Exception e) {
        if (Assertions.ENABLED) {
            assert (globalCheckpoint >= -2L) : globalCheckpoint;
            if (globalCheckpoint != -2L) {
                assert (e == null) : e;
            } else {
                assert (e != null);
                assert (e instanceof IndexShardClosedException || e instanceof TimeoutException) : e;
            }
        }
    }

    public static interface GlobalCheckpointListener {
        public Executor executor();

        public void accept(long var1, Exception var3);
    }
}

