/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.CloseableRetryableRefreshListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardState;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public class CheckpointRefreshListener
extends CloseableRetryableRefreshListener {
    protected static Logger logger = LogManager.getLogger(CheckpointRefreshListener.class);
    private final IndexShard shard;
    private final SegmentReplicationCheckpointPublisher publisher;

    public CheckpointRefreshListener(IndexShard shard, SegmentReplicationCheckpointPublisher publisher) {
        this.shard = shard;
        this.publisher = publisher;
    }

    @Override
    public void beforeRefresh() throws IOException {
    }

    @Override
    protected boolean performAfterRefreshWithPermit(boolean didRefresh) {
        if (didRefresh && this.shard.state() == IndexShardState.STARTED && this.shard.getReplicationTracker().isPrimaryMode() && !this.shard.indexSettings.isSegRepWithRemoteEnabled()) {
            this.publisher.publish(this.shard, this.shard.getLatestReplicationCheckpoint());
        }
        return true;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

