/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.MovingAverage;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;

public abstract class RemoteTransferTracker {
    protected final ShardId shardId;
    protected final AtomicLong totalUploadTimeInMillis;
    protected final AtomicLong totalUploadsStarted;
    protected final AtomicLong totalUploadsFailed;
    protected final AtomicLong totalUploadsSucceeded;
    protected final AtomicLong uploadBytesStarted;
    protected final AtomicLong uploadBytesFailed;
    protected final AtomicLong uploadBytesSucceeded;
    protected final AtomicReference<MovingAverage> uploadBytesMovingAverageReference;
    protected final Object uploadBytesMutex;
    protected final AtomicReference<MovingAverage> uploadBytesPerSecMovingAverageReference;
    protected final Object uploadBytesPerSecMutex;
    protected final AtomicReference<MovingAverage> uploadTimeMsMovingAverageReference;
    protected final Object uploadTimeMsMutex;

    public RemoteTransferTracker(ShardId shardId, int movingAverageWindowSize) {
        this.shardId = shardId;
        this.totalUploadTimeInMillis = new AtomicLong(0L);
        this.totalUploadsStarted = new AtomicLong(0L);
        this.totalUploadsFailed = new AtomicLong(0L);
        this.totalUploadsSucceeded = new AtomicLong(0L);
        this.uploadBytesStarted = new AtomicLong(0L);
        this.uploadBytesFailed = new AtomicLong(0L);
        this.uploadBytesSucceeded = new AtomicLong(0L);
        this.uploadBytesMutex = new Object();
        this.uploadBytesMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
        this.uploadBytesPerSecMutex = new Object();
        this.uploadBytesPerSecMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
        this.uploadTimeMsMutex = new Object();
        this.uploadTimeMsMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
    }

    ShardId getShardId() {
        return this.shardId;
    }

    public long getTotalUploadTimeInMillis() {
        return this.totalUploadTimeInMillis.get();
    }

    public void addUploadTimeInMillis(long duration) {
        this.totalUploadTimeInMillis.addAndGet(duration);
    }

    public long getTotalUploadsStarted() {
        return this.totalUploadsStarted.get();
    }

    public long getTotalUploadsFailed() {
        return this.totalUploadsFailed.get();
    }

    public long getTotalUploadsSucceeded() {
        return this.totalUploadsSucceeded.get();
    }

    public void incrementTotalUploadsStarted() {
        this.totalUploadsStarted.addAndGet(1L);
    }

    public void incrementTotalUploadsFailed() {
        this.checkTotal(this.totalUploadsStarted.get(), this.totalUploadsFailed.get(), this.totalUploadsSucceeded.get(), 1L);
        this.totalUploadsFailed.addAndGet(1L);
    }

    public void incrementTotalUploadsSucceeded() {
        this.checkTotal(this.totalUploadsStarted.get(), this.totalUploadsFailed.get(), this.totalUploadsSucceeded.get(), 1L);
        this.totalUploadsSucceeded.addAndGet(1L);
    }

    public long getUploadBytesStarted() {
        return this.uploadBytesStarted.get();
    }

    public long getUploadBytesFailed() {
        return this.uploadBytesFailed.get();
    }

    public long getUploadBytesSucceeded() {
        return this.uploadBytesSucceeded.get();
    }

    public void addUploadBytesStarted(long count) {
        this.uploadBytesStarted.addAndGet(count);
    }

    public void addUploadBytesFailed(long count) {
        this.checkTotal(this.uploadBytesStarted.get(), this.uploadBytesFailed.get(), this.uploadBytesSucceeded.get(), count);
        this.uploadBytesFailed.addAndGet(count);
    }

    public void addUploadBytesSucceeded(long count) {
        this.checkTotal(this.uploadBytesStarted.get(), this.uploadBytesFailed.get(), this.uploadBytesSucceeded.get(), count);
        this.uploadBytesSucceeded.addAndGet(count);
    }

    boolean isUploadBytesMovingAverageReady() {
        return this.uploadBytesMovingAverageReference.get().isReady();
    }

    double getUploadBytesMovingAverage() {
        return this.uploadBytesMovingAverageReference.get().getAverage();
    }

    public void updateUploadBytesMovingAverage(long count) {
        this.updateMovingAverage(count, this.uploadBytesMutex, this.uploadBytesMovingAverageReference);
    }

    boolean isUploadBytesPerSecMovingAverageReady() {
        return this.uploadBytesPerSecMovingAverageReference.get().isReady();
    }

    double getUploadBytesPerSecMovingAverage() {
        return this.uploadBytesPerSecMovingAverageReference.get().getAverage();
    }

    public void updateUploadBytesPerSecMovingAverage(long speed) {
        this.updateMovingAverage(speed, this.uploadBytesPerSecMutex, this.uploadBytesPerSecMovingAverageReference);
    }

    boolean isUploadTimeMovingAverageReady() {
        return this.uploadTimeMsMovingAverageReference.get().isReady();
    }

    double getUploadTimeMovingAverage() {
        return this.uploadTimeMsMovingAverageReference.get().getAverage();
    }

    public void updateUploadTimeMovingAverage(long duration) {
        this.updateMovingAverage(duration, this.uploadTimeMsMutex, this.uploadTimeMsMovingAverageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMovingAverage(long value, Object mutex, AtomicReference<MovingAverage> movingAverageReference) {
        Object object = mutex;
        synchronized (object) {
            movingAverageReference.get().record(value);
        }
    }

    void updateMovingAverageWindowSize(int updatedSize) {
        this.updateMovingAverageWindowSize(updatedSize, this.uploadBytesMutex, this.uploadBytesMovingAverageReference);
        this.updateMovingAverageWindowSize(updatedSize, this.uploadBytesPerSecMutex, this.uploadBytesPerSecMovingAverageReference);
        this.updateMovingAverageWindowSize(updatedSize, this.uploadTimeMsMutex, this.uploadTimeMsMovingAverageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMovingAverageWindowSize(int updatedSize, Object mutex, AtomicReference<MovingAverage> movingAverageReference) {
        Object object = mutex;
        synchronized (object) {
            movingAverageReference.set(movingAverageReference.get().copyWithSize(updatedSize));
        }
    }

    private void checkTotal(long startedCount, long failedCount, long succeededCount, long countToAdd) {
        long delta = startedCount - (failedCount + succeededCount + countToAdd);
        assert (delta >= 0L) : "Sum of failure count (" + failedCount + "), success count (" + succeededCount + "), and count to add (" + countToAdd + ") cannot exceed started count (" + startedCount + ")";
    }
}

