/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteSegmentTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePressureSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;

public class RemoteStorePressureService {
    private static final Logger logger = LogManager.getLogger(RemoteStorePressureService.class);
    private final RemoteStorePressureSettings pressureSettings;
    private final List<LagValidator> lagValidators;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;

    @Inject
    public RemoteStorePressureService(ClusterService clusterService, Settings settings, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory) {
        this.pressureSettings = new RemoteStorePressureSettings(clusterService, settings, this);
        this.lagValidators = Arrays.asList(new ConsecutiveFailureValidator(this.pressureSettings), new BytesLagValidator(this.pressureSettings), new TimeLagValidator(this.pressureSettings));
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
    }

    public boolean isSegmentsUploadBackpressureEnabled() {
        return this.pressureSettings.isRemoteRefreshSegmentPressureEnabled();
    }

    public void validateSegmentsUploadLag(ShardId shardId) {
        RemoteSegmentTransferTracker remoteSegmentTransferTracker = this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(shardId);
        if (remoteSegmentTransferTracker == null || remoteSegmentTransferTracker.getRefreshSeqNoLag() == 0L) {
            return;
        }
        for (LagValidator lagValidator : this.lagValidators) {
            if (lagValidator.validate(remoteSegmentTransferTracker, shardId)) continue;
            remoteSegmentTransferTracker.incrementRejectionCount(lagValidator.name());
            throw new OpenSearchRejectedExecutionException(lagValidator.rejectionMessage(remoteSegmentTransferTracker, shardId));
        }
    }

    private static abstract class LagValidator {
        final RemoteStorePressureSettings pressureSettings;

        private LagValidator(RemoteStorePressureSettings pressureSettings) {
            this.pressureSettings = pressureSettings;
        }

        abstract boolean validate(RemoteSegmentTransferTracker var1, ShardId var2);

        abstract String name();

        abstract String rejectionMessage(RemoteSegmentTransferTracker var1, ShardId var2);
    }

    private static class ConsecutiveFailureValidator
    extends LagValidator {
        private static final String NAME = "consecutive_failures_lag";

        private ConsecutiveFailureValidator(RemoteStorePressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            int minConsecutiveFailureThreshold;
            int failureStreakCount = pressureTracker.getConsecutiveFailureCount();
            return failureStreakCount <= (minConsecutiveFailureThreshold = this.pressureSettings.getMinConsecutiveFailuresLimit());
        }

        @Override
        public String rejectionMessage(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.failure_streak_count:%s min_consecutive_failure_threshold:%s", shardId, pressureTracker.getConsecutiveFailureCount(), this.pressureSettings.getMinConsecutiveFailuresLimit());
        }

        @Override
        String name() {
            return NAME;
        }
    }

    private static class BytesLagValidator
    extends LagValidator {
        private static final String NAME = "bytes_lag";

        private BytesLagValidator(RemoteStorePressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            if (pressureTracker.getRefreshSeqNoLag() <= 1L) {
                return true;
            }
            if (!pressureTracker.isUploadBytesMovingAverageReady()) {
                logger.trace("upload bytes moving average is not ready");
                return true;
            }
            double dynamicBytesLagThreshold = pressureTracker.getUploadBytesMovingAverage() * this.pressureSettings.getBytesLagVarianceFactor();
            long bytesLag = pressureTracker.getBytesLag();
            return (double)bytesLag <= dynamicBytesLagThreshold;
        }

        @Override
        public String rejectionMessage(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            double dynamicBytesLagThreshold = pressureTracker.getUploadBytesMovingAverage() * this.pressureSettings.getBytesLagVarianceFactor();
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.bytes_lag:%s dynamic_bytes_lag_threshold:%s", shardId, pressureTracker.getBytesLag(), dynamicBytesLagThreshold);
        }

        @Override
        String name() {
            return NAME;
        }
    }

    private static class TimeLagValidator
    extends LagValidator {
        private static final String NAME = "time_lag";

        private TimeLagValidator(RemoteStorePressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            double dynamicTimeLagThreshold;
            if (pressureTracker.getRefreshSeqNoLag() <= 1L) {
                return true;
            }
            if (!pressureTracker.isUploadTimeMovingAverageReady()) {
                logger.trace("upload time moving average is not ready");
                return true;
            }
            long timeLag = pressureTracker.getTimeMsLag();
            return (double)timeLag <= (dynamicTimeLagThreshold = pressureTracker.getUploadTimeMovingAverage() * this.pressureSettings.getUploadTimeLagVarianceFactor());
        }

        @Override
        public String rejectionMessage(RemoteSegmentTransferTracker pressureTracker, ShardId shardId) {
            double dynamicTimeLagThreshold = pressureTracker.getUploadTimeMovingAverage() * this.pressureSettings.getUploadTimeLagVarianceFactor();
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.time_lag:%s ms dynamic_time_lag_threshold:%s ms", shardId, pressureTracker.getTimeMsLag(), dynamicTimeLagThreshold);
        }

        @Override
        String name() {
            return NAME;
        }
    }
}

