/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteSegmentTransferTracker;

public class RemoteSegmentStats
implements Writeable,
ToXContentFragment {
    private long uploadBytesStarted;
    private long uploadBytesFailed;
    private long uploadBytesSucceeded;
    private long downloadBytesStarted;
    private long downloadBytesFailed;
    private long downloadBytesSucceeded;
    private long maxRefreshTimeLag;
    private long maxRefreshBytesLag;
    private long totalRefreshBytesLag;
    private long totalUploadTime;
    private long totalDownloadTime;

    public RemoteSegmentStats() {
    }

    public RemoteSegmentStats(StreamInput in) throws IOException {
        this.uploadBytesStarted = in.readLong();
        this.uploadBytesFailed = in.readLong();
        this.uploadBytesSucceeded = in.readLong();
        this.downloadBytesStarted = in.readLong();
        this.downloadBytesFailed = in.readLong();
        this.downloadBytesSucceeded = in.readLong();
        this.maxRefreshTimeLag = in.readLong();
        this.maxRefreshBytesLag = in.readLong();
        this.totalRefreshBytesLag = in.readLong();
        this.totalUploadTime = in.readLong();
        this.totalDownloadTime = in.readLong();
    }

    public RemoteSegmentStats(RemoteSegmentTransferTracker.Stats trackerStats) {
        this.uploadBytesStarted = trackerStats.uploadBytesStarted;
        this.uploadBytesFailed = trackerStats.uploadBytesFailed;
        this.uploadBytesSucceeded = trackerStats.uploadBytesSucceeded;
        this.downloadBytesSucceeded = trackerStats.directoryFileTransferTrackerStats.transferredBytesSucceeded;
        this.downloadBytesStarted = trackerStats.directoryFileTransferTrackerStats.transferredBytesStarted;
        this.downloadBytesFailed = trackerStats.directoryFileTransferTrackerStats.transferredBytesFailed;
        this.maxRefreshTimeLag = trackerStats.refreshTimeLagMs;
        this.maxRefreshBytesLag = trackerStats.bytesLag;
        this.totalRefreshBytesLag = trackerStats.bytesLag;
        this.totalUploadTime = trackerStats.totalUploadTimeInMs;
        this.totalDownloadTime = trackerStats.directoryFileTransferTrackerStats.totalTransferTimeInMs;
    }

    public long getUploadBytesStarted() {
        return this.uploadBytesStarted;
    }

    public void addUploadBytesStarted(long uploadsStarted) {
        this.uploadBytesStarted += uploadsStarted;
    }

    public long getUploadBytesFailed() {
        return this.uploadBytesFailed;
    }

    public void addUploadBytesFailed(long uploadsFailed) {
        this.uploadBytesFailed += uploadsFailed;
    }

    public long getUploadBytesSucceeded() {
        return this.uploadBytesSucceeded;
    }

    public void addUploadBytesSucceeded(long uploadsSucceeded) {
        this.uploadBytesSucceeded += uploadsSucceeded;
    }

    public long getDownloadBytesStarted() {
        return this.downloadBytesStarted;
    }

    public void addDownloadBytesStarted(long downloadsStarted) {
        this.downloadBytesStarted += downloadsStarted;
    }

    public long getDownloadBytesFailed() {
        return this.downloadBytesFailed;
    }

    public void addDownloadBytesFailed(long downloadsFailed) {
        this.downloadBytesFailed += downloadsFailed;
    }

    public long getDownloadBytesSucceeded() {
        return this.downloadBytesSucceeded;
    }

    public void addDownloadBytesSucceeded(long downloadsSucceeded) {
        this.downloadBytesSucceeded += downloadsSucceeded;
    }

    public long getMaxRefreshTimeLag() {
        return this.maxRefreshTimeLag;
    }

    public void setMaxRefreshTimeLag(long maxRefreshTimeLag) {
        this.maxRefreshTimeLag = Math.max(this.maxRefreshTimeLag, maxRefreshTimeLag);
    }

    public long getMaxRefreshBytesLag() {
        return this.maxRefreshBytesLag;
    }

    public void addMaxRefreshBytesLag(long maxRefreshBytesLag) {
        this.maxRefreshBytesLag = Math.max(this.maxRefreshBytesLag, maxRefreshBytesLag);
    }

    public long getTotalRefreshBytesLag() {
        return this.totalRefreshBytesLag;
    }

    public void addTotalRefreshBytesLag(long totalRefreshBytesLag) {
        this.totalRefreshBytesLag += totalRefreshBytesLag;
    }

    public long getTotalUploadTime() {
        return this.totalUploadTime;
    }

    public void addTotalUploadTime(long totalUploadTime) {
        this.totalUploadTime += totalUploadTime;
    }

    public long getTotalDownloadTime() {
        return this.totalDownloadTime;
    }

    public void addTotalDownloadTime(long totalDownloadTime) {
        this.totalDownloadTime += totalDownloadTime;
    }

    public void add(RemoteSegmentStats existingStats) {
        if (existingStats != null) {
            this.uploadBytesStarted += existingStats.getUploadBytesStarted();
            this.uploadBytesSucceeded += existingStats.getUploadBytesSucceeded();
            this.uploadBytesFailed += existingStats.getUploadBytesFailed();
            this.downloadBytesStarted += existingStats.getDownloadBytesStarted();
            this.downloadBytesFailed += existingStats.getDownloadBytesFailed();
            this.downloadBytesSucceeded += existingStats.getDownloadBytesSucceeded();
            this.maxRefreshTimeLag = Math.max(this.maxRefreshTimeLag, existingStats.getMaxRefreshTimeLag());
            this.maxRefreshBytesLag = Math.max(this.maxRefreshBytesLag, existingStats.getMaxRefreshBytesLag());
            this.totalRefreshBytesLag += existingStats.getTotalRefreshBytesLag();
            this.totalUploadTime += existingStats.getTotalUploadTime();
            this.totalDownloadTime += existingStats.getTotalDownloadTime();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.uploadBytesStarted);
        out.writeLong(this.uploadBytesFailed);
        out.writeLong(this.uploadBytesSucceeded);
        out.writeLong(this.downloadBytesStarted);
        out.writeLong(this.downloadBytesFailed);
        out.writeLong(this.downloadBytesSucceeded);
        out.writeLong(this.maxRefreshTimeLag);
        out.writeLong(this.maxRefreshBytesLag);
        out.writeLong(this.totalRefreshBytesLag);
        out.writeLong(this.totalUploadTime);
        out.writeLong(this.totalDownloadTime);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("remote_store");
        builder.startObject("upload");
        this.buildUploadStats(builder);
        builder.endObject();
        builder.startObject("download");
        this.buildDownloadStats(builder);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private void buildUploadStats(XContentBuilder builder) throws IOException {
        builder.startObject("total_upload_size");
        builder.humanReadableField("started_bytes", "started", new ByteSizeValue(this.uploadBytesStarted));
        builder.humanReadableField("succeeded_bytes", "succeeded", new ByteSizeValue(this.uploadBytesSucceeded));
        builder.humanReadableField("failed_bytes", "failed", new ByteSizeValue(this.uploadBytesFailed));
        builder.endObject();
        builder.startObject("refresh_size_lag");
        builder.humanReadableField("total_bytes", "total", new ByteSizeValue(this.totalRefreshBytesLag));
        builder.humanReadableField("max_bytes", "max", new ByteSizeValue(this.maxRefreshBytesLag));
        builder.endObject();
        builder.humanReadableField("max_refresh_time_lag_in_millis", "max_refresh_time_lag", new TimeValue(this.maxRefreshTimeLag));
        builder.humanReadableField("total_time_spent_in_millis", "total_time_spent", new TimeValue(this.totalUploadTime));
    }

    private void buildDownloadStats(XContentBuilder builder) throws IOException {
        builder.startObject("total_download_size");
        builder.humanReadableField("started_bytes", "started", new ByteSizeValue(this.downloadBytesStarted));
        builder.humanReadableField("succeeded_bytes", "succeeded", new ByteSizeValue(this.downloadBytesSucceeded));
        builder.humanReadableField("failed_bytes", "failed", new ByteSizeValue(this.downloadBytesFailed));
        builder.endObject();
        builder.humanReadableField("total_time_spent_in_millis", "total_time_spent", new TimeValue(this.totalDownloadTime));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSegmentStats that = (RemoteSegmentStats)o;
        return this.uploadBytesStarted == that.uploadBytesStarted && this.uploadBytesFailed == that.uploadBytesFailed && this.uploadBytesSucceeded == that.uploadBytesSucceeded && this.downloadBytesStarted == that.downloadBytesStarted && this.downloadBytesFailed == that.downloadBytesFailed && this.downloadBytesSucceeded == that.downloadBytesSucceeded && this.maxRefreshTimeLag == that.maxRefreshTimeLag && this.maxRefreshBytesLag == that.maxRefreshBytesLag && this.totalRefreshBytesLag == that.totalRefreshBytesLag && this.totalUploadTime == that.totalUploadTime && this.totalDownloadTime == that.totalDownloadTime;
    }

    public int hashCode() {
        return Objects.hash(this.uploadBytesStarted, this.uploadBytesFailed, this.uploadBytesSucceeded, this.downloadBytesStarted, this.downloadBytesFailed, this.downloadBytesSucceeded, this.maxRefreshTimeLag, this.maxRefreshBytesLag, this.totalRefreshBytesLag, this.totalUploadTime, this.totalDownloadTime);
    }

    static final class Fields {
        static final String REMOTE_STORE = "remote_store";
        static final String UPLOAD = "upload";
        static final String DOWNLOAD = "download";
        static final String TOTAL_UPLOAD_SIZE = "total_upload_size";
        static final String TOTAL_DOWNLOAD_SIZE = "total_download_size";
        static final String MAX_REFRESH_TIME_LAG = "max_refresh_time_lag";
        static final String MAX_REFRESH_TIME_LAG_IN_MILLIS = "max_refresh_time_lag_in_millis";
        static final String REFRESH_SIZE_LAG = "refresh_size_lag";
        static final String STARTED = "started";
        static final String STARTED_BYTES = "started_bytes";
        static final String FAILED = "failed";
        static final String FAILED_BYTES = "failed_bytes";
        static final String SUCCEEDED = "succeeded";
        static final String SUCCEEDED_BYTES = "succeeded_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_BYTES = "total_bytes";
        static final String MAX = "max";
        static final String MAX_BYTES = "max_bytes";
        static final String TOTAL_TIME_SPENT = "total_time_spent";
        static final String TOTAL_TIME_SPENT_IN_MILLIS = "total_time_spent_in_millis";

        Fields() {
        }
    }
}

