/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoDistance;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.CombineFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.LeafScoreFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.ScoreFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.DistanceUnit;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexGeoPointFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafGeoPointFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.MultiGeoPointValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.NumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortingNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoPointFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumberFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.DecayFunction;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.DecayFunctionParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.MultiValueMode;

public abstract class DecayFunctionBuilder<DFB extends DecayFunctionBuilder<DFB>>
extends ScoreFunctionBuilder<DFB> {
    protected static final String ORIGIN = "origin";
    protected static final String SCALE = "scale";
    protected static final String DECAY = "decay";
    protected static final String OFFSET = "offset";
    public static final double DEFAULT_DECAY = 0.5;
    public static final MultiValueMode DEFAULT_MULTI_VALUE_MODE = MultiValueMode.MIN;
    private final String fieldName;
    private final BytesReference functionBytes;
    private MultiValueMode multiValueMode = DEFAULT_MULTI_VALUE_MODE;

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset) {
        this(fieldName, origin, scale, offset, 0.5);
    }

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, @Nullable String functionName) {
        this(fieldName, origin, scale, offset, 0.5, functionName);
    }

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay) {
        this(fieldName, origin, scale, offset, decay, null);
    }

    protected DecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay, @Nullable String functionName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("decay function: field name must not be null");
        }
        if (scale == null) {
            throw new IllegalArgumentException("decay function: scale must not be null");
        }
        if (decay <= 0.0 || decay >= 1.0) {
            throw new IllegalStateException("decay function: decay must be in range 0..1!");
        }
        this.fieldName = fieldName;
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (origin != null) {
                builder.field(ORIGIN, origin);
            }
            builder.field(SCALE, scale);
            if (offset != null) {
                builder.field(OFFSET, offset);
            }
            builder.field(DECAY, decay);
            builder.endObject();
            this.functionBytes = BytesReference.bytes(builder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to build inner function object", e);
        }
        this.setFunctionName(functionName);
    }

    protected DecayFunctionBuilder(String fieldName, BytesReference functionBytes) {
        if (fieldName == null) {
            throw new IllegalArgumentException("decay function: field name must not be null");
        }
        if (functionBytes == null) {
            throw new IllegalArgumentException("decay function: function must not be null");
        }
        this.fieldName = fieldName;
        this.functionBytes = functionBytes;
    }

    protected DecayFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.functionBytes = in.readBytesReference();
        this.multiValueMode = MultiValueMode.readMultiValueModeFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeBytesReference(this.functionBytes);
        this.multiValueMode.writeTo(out);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BytesReference getFunctionBytes() {
        return this.functionBytes;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        try (StreamInput stream = this.functionBytes.streamInput();){
            builder.rawField(this.fieldName, stream);
        }
        builder.field(DecayFunctionParser.MULTI_VALUE_MODE.getPreferredName(), this.multiValueMode.name());
        builder.endObject();
    }

    public DFB setMultiValueMode(MultiValueMode multiValueMode) {
        if (multiValueMode == null) {
            throw new IllegalArgumentException("decay function: multi_value_mode must not be null");
        }
        this.multiValueMode = multiValueMode;
        return (DFB)this;
    }

    public MultiValueMode getMultiValueMode() {
        return this.multiValueMode;
    }

    @Override
    protected boolean doEquals(DFB functionBuilder) {
        return Objects.equals(this.fieldName, ((DecayFunctionBuilder)functionBuilder).getFieldName()) && Objects.equals(this.functionBytes, ((DecayFunctionBuilder)functionBuilder).getFunctionBytes()) && Objects.equals(this.multiValueMode, ((DecayFunctionBuilder)functionBuilder).getMultiValueMode());
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.functionBytes, this.multiValueMode);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) throws IOException {
        AbstractDistanceScoreFunction scoreFunction;
        try (StreamInput stream = this.functionBytes.streamInput();
             XContentParser parser = MediaTypeRegistry.xContentType(this.functionBytes).xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
            scoreFunction = this.parseVariable(this.fieldName, parser, context, this.multiValueMode);
        }
        return scoreFunction;
    }

    protected abstract DecayFunction getDecayFunction();

    private AbstractDistanceScoreFunction parseVariable(String fieldName, XContentParser parser, QueryShardContext context, MultiValueMode mode) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (fieldType == null) {
            throw new ParsingException(parser.getTokenLocation(), "unknown field [{}]", fieldName);
        }
        parser.nextToken();
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            return this.parseDateVariable(parser, context, fieldType, mode);
        }
        if (fieldType instanceof GeoPointFieldMapper.GeoPointFieldType) {
            return this.parseGeoVariable(parser, context, fieldType, mode);
        }
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return this.parseNumberVariable(parser, context, fieldType, mode);
        }
        throw new ParsingException(parser.getTokenLocation(), "field [{}] is of type [{}], but only numeric types are supported.", fieldName, fieldType);
    }

    private AbstractDistanceScoreFunction parseNumberVariable(XContentParser parser, QueryShardContext context, MappedFieldType fieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        double scale = 0.0;
        double origin = 0.0;
        double decay = 0.5;
        double offset = 0.0;
        boolean scaleFound = false;
        boolean refFound = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (SCALE.equals(parameterName)) {
                scale = parser.doubleValue();
                scaleFound = true;
                continue;
            }
            if (DECAY.equals(parameterName)) {
                decay = parser.doubleValue();
                continue;
            }
            if (ORIGIN.equals(parameterName)) {
                origin = parser.doubleValue();
                refFound = true;
                continue;
            }
            if (OFFSET.equals(parameterName)) {
                offset = parser.doubleValue();
                continue;
            }
            throw new OpenSearchParseException("parameter [{}] not supported!", parameterName);
        }
        if (!scaleFound || !refFound) {
            throw new OpenSearchParseException("both [{}] and [{}] must be set for numeric fields.", SCALE, ORIGIN);
        }
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)context.getForField(fieldType);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode, this.getFunctionName());
    }

    private AbstractDistanceScoreFunction parseGeoVariable(XContentParser parser, QueryShardContext context, MappedFieldType fieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        GeoPoint origin = new GeoPoint();
        String scaleString = null;
        String offsetString = "0km";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (SCALE.equals(parameterName)) {
                scaleString = parser.text();
                continue;
            }
            if (ORIGIN.equals(parameterName)) {
                origin = GeoUtils.parseGeoPoint(parser);
                continue;
            }
            if (DECAY.equals(parameterName)) {
                decay = parser.doubleValue();
                continue;
            }
            if (OFFSET.equals(parameterName)) {
                offsetString = parser.text();
                continue;
            }
            throw new OpenSearchParseException("parameter [{}] not supported!", parameterName);
        }
        if (origin == null || scaleString == null) {
            throw new OpenSearchParseException("[{}] and [{}] must be set for geo fields.", ORIGIN, SCALE);
        }
        double scale = DistanceUnit.DEFAULT.parse(scaleString, DistanceUnit.DEFAULT);
        double offset = DistanceUnit.DEFAULT.parse(offsetString, DistanceUnit.DEFAULT);
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)context.getForField(fieldType);
        return new GeoFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), indexFieldData, mode, this.getFunctionName());
    }

    private AbstractDistanceScoreFunction parseDateVariable(XContentParser parser, QueryShardContext context, MappedFieldType dateFieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        String scaleString = null;
        String originString = null;
        String offsetString = "0d";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (SCALE.equals(parameterName)) {
                scaleString = parser.text();
                continue;
            }
            if (ORIGIN.equals(parameterName)) {
                originString = parser.text();
                continue;
            }
            if (DECAY.equals(parameterName)) {
                decay = parser.doubleValue();
                continue;
            }
            if (OFFSET.equals(parameterName)) {
                offsetString = parser.text();
                continue;
            }
            throw new OpenSearchParseException("parameter [{}] not supported!", parameterName);
        }
        long origin = originString == null ? context.nowInMillis() : ((DateFieldMapper.DateFieldType)dateFieldType).parseToLong(originString, false, null, null, context::nowInMillis);
        if (scaleString == null) {
            throw new OpenSearchParseException("[{}] must be set for date fields.", SCALE);
        }
        TimeValue val = TimeValue.parseTimeValue(scaleString, TimeValue.timeValueHours(24L), DecayFunctionParser.class.getSimpleName() + ".scale");
        double scale = val.getMillis();
        val = TimeValue.parseTimeValue(offsetString, TimeValue.timeValueHours(24L), DecayFunctionParser.class.getSimpleName() + ".offset");
        double offset = val.getMillis();
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)context.getForField(dateFieldType);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode, this.getFunctionName());
    }

    public static abstract class AbstractDistanceScoreFunction
    extends ScoreFunction {
        private final double scale;
        protected final double offset;
        private final DecayFunction func;
        protected final MultiValueMode mode;
        protected final String functionName;

        public AbstractDistanceScoreFunction(double userSuppiedScale, double decay, double offset, DecayFunction func, MultiValueMode mode, @Nullable String functionName) {
            super(CombineFunction.MULTIPLY);
            this.mode = mode;
            if (userSuppiedScale <= 0.0) {
                throw new IllegalArgumentException("function_score : scale must be > 0.0.");
            }
            if (decay <= 0.0 || decay >= 1.0) {
                throw new IllegalArgumentException("function_score : decay must be in the range [0..1].");
            }
            this.scale = func.processScale(userSuppiedScale, decay);
            this.func = func;
            if (offset < 0.0) {
                throw new IllegalArgumentException("function_score : offset must be > 0.0");
            }
            this.offset = offset;
            this.functionName = functionName;
        }

        protected abstract NumericDoubleValues distance(LeafReaderContext var1);

        @Override
        public final LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
            final NumericDoubleValues distance = this.distance(ctx);
            return new LeafScoreFunction(){

                @Override
                public double score(int docId, float subQueryScore) throws IOException {
                    if (distance.advanceExact(docId)) {
                        return func.evaluate(distance.doubleValue(), scale);
                    }
                    return 0.0;
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                    if (!distance.advanceExact(docId)) {
                        return Explanation.noMatch("No value for the distance", new Explanation[0]);
                    }
                    double value = distance.doubleValue();
                    return Explanation.match((Number)Float.valueOf((float)this.score(docId, subQueryScore.getValue().floatValue())), "Function for field " + this.getFieldName() + ":", func.explainFunction(this.getDistanceString(ctx, docId), value, scale, functionName));
                }
            };
        }

        protected abstract String getDistanceString(LeafReaderContext var1, int var2) throws IOException;

        protected abstract String getFieldName();

        @Override
        protected boolean doEquals(ScoreFunction other) {
            AbstractDistanceScoreFunction distanceScoreFunction = (AbstractDistanceScoreFunction)other;
            return Objects.equals(this.scale, distanceScoreFunction.scale) && Objects.equals(this.offset, distanceScoreFunction.offset) && Objects.equals(this.mode, distanceScoreFunction.mode) && Objects.equals(this.func, distanceScoreFunction.func) && Objects.equals(this.getFieldName(), distanceScoreFunction.getFieldName());
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(this.scale, this.offset, this.mode, this.func, this.getFieldName());
        }
    }

    static class NumericFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final IndexNumericFieldData fieldData;
        private final double origin;

        NumericFieldDataScoreFunction(double origin, double scale, double decay, double offset, DecayFunction func, IndexNumericFieldData fieldData, MultiValueMode mode, @Nullable String functionName) {
            super(scale, decay, offset, func, mode, functionName);
            this.fieldData = fieldData;
            this.origin = origin;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final SortedNumericDoubleValues doubleValues = ((LeafNumericFieldData)this.fieldData.load(context)).getDoubleValues();
            return FieldData.replaceMissing(this.mode.select(new SortingNumericDoubleValues(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    if (doubleValues.advanceExact(docId)) {
                        int n = doubleValues.docValueCount();
                        this.resize(n);
                        for (int i = 0; i < n; ++i) {
                            this.values[i] = Math.max(0.0, Math.abs(doubleValues.nextValue() - origin) - offset);
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }), 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) throws IOException {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append("[");
            SortedNumericDoubleValues doubleValues = ((LeafNumericFieldData)this.fieldData.load(ctx)).getDoubleValues();
            if (doubleValues.advanceExact(docId)) {
                int num = doubleValues.docValueCount();
                for (int i = 0; i < num; ++i) {
                    double value = doubleValues.nextValue();
                    values.append("Math.max(Math.abs(");
                    values.append(value).append("(=doc value) - ");
                    values.append(this.origin).append("(=origin))) - ");
                    values.append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldName();
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            NumericFieldDataScoreFunction numericFieldDataScoreFunction = (NumericFieldDataScoreFunction)other;
            if (!super.doEquals(other)) {
                return false;
            }
            return Objects.equals(this.origin, numericFieldDataScoreFunction.origin);
        }
    }

    static class GeoFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final GeoPoint origin;
        private final IndexGeoPointFieldData fieldData;
        private static final GeoDistance distFunction = GeoDistance.ARC;

        GeoFieldDataScoreFunction(GeoPoint origin, double scale, double decay, double offset, DecayFunction func, IndexGeoPointFieldData fieldData, MultiValueMode mode, @Nullable String functionName) {
            super(scale, decay, offset, func, mode, functionName);
            this.origin = origin;
            this.fieldData = fieldData;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final MultiGeoPointValues geoPointValues = ((LeafGeoPointFieldData)this.fieldData.load(context)).getGeoPointValues();
            return FieldData.replaceMissing(this.mode.select(new SortingNumericDoubleValues(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    if (geoPointValues.advanceExact(docId)) {
                        int n = geoPointValues.docValueCount();
                        this.resize(n);
                        for (int i = 0; i < n; ++i) {
                            GeoPoint other = geoPointValues.nextValue();
                            double distance = distFunction.calculate(origin.lat(), origin.lon(), other.lat(), other.lon(), DistanceUnit.METERS);
                            this.values[i] = Math.max(0.0, distance - offset);
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }), 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) throws IOException {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append(" of: [");
            MultiGeoPointValues geoPointValues = ((LeafGeoPointFieldData)this.fieldData.load(ctx)).getGeoPointValues();
            if (geoPointValues.advanceExact(docId)) {
                int num = geoPointValues.docValueCount();
                for (int i = 0; i < num; ++i) {
                    GeoPoint value = geoPointValues.nextValue();
                    values.append("Math.max(arcDistance(");
                    values.append(value).append("(=doc value),");
                    values.append(this.origin).append("(=origin)) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldName();
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            GeoFieldDataScoreFunction geoFieldDataScoreFunction = (GeoFieldDataScoreFunction)other;
            return super.doEquals(other) && Objects.equals(this.origin, geoFieldDataScoreFunction.origin);
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(super.doHashCode(), this.origin);
        }
    }
}

