/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.util.CollectionUtils;

public enum GeoValidationMethod implements Writeable
{
    COERCE,
    IGNORE_MALFORMED,
    STRICT;

    public static final GeoValidationMethod DEFAULT;
    public static final boolean DEFAULT_LENIENT_PARSING;

    public static GeoValidationMethod readFromStream(StreamInput in) throws IOException {
        return GeoValidationMethod.values()[in.readVInt()];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static GeoValidationMethod fromString(String op) {
        for (GeoValidationMethod method : GeoValidationMethod.values()) {
            if (!method.name().equalsIgnoreCase(op)) continue;
            return method;
        }
        throw new IllegalArgumentException("operator needs to be either " + CollectionUtils.arrayAsArrayList(GeoValidationMethod.values()) + ", but not [" + op + "]");
    }

    public static boolean isIgnoreMalformed(GeoValidationMethod method) {
        return method == IGNORE_MALFORMED || method == COERCE;
    }

    public static boolean isCoerce(GeoValidationMethod method) {
        return method == COERCE;
    }

    public static GeoValidationMethod infer(boolean coerce, boolean ignoreMalformed) {
        if (coerce) {
            return COERCE;
        }
        if (ignoreMalformed) {
            return IGNORE_MALFORMED;
        }
        return STRICT;
    }

    static {
        DEFAULT = STRICT;
        DEFAULT_LENIENT_PARSING = DEFAULT != STRICT;
    }
}

