/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.BytesRefs;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.SuggestingErrorOnUnknown;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.AbstractObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedObjectNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentLocation;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.InnerHitContextBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryRewriteContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryValidationException;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder<QB>>
implements QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    public static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    protected String queryName;
    protected float boost = 1.0f;

    protected AbstractQueryBuilder() {
    }

    protected AbstractQueryBuilder(StreamInput in) throws IOException {
        this.boost = in.readFloat();
        this.checkNegativeBoost(this.boost);
        this.queryName = in.readOptionalString();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.boost);
        out.writeOptionalString(this.queryName);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected void printBoostAndQueryName(XContentBuilder builder) throws IOException {
        builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        if (this.queryName != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.queryName);
        }
    }

    @Override
    public final Query toQuery(QueryShardContext context) throws IOException {
        Query query = this.doToQuery(context);
        if (query != null) {
            if (this.boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                query = new BoostQuery(query, this.boost);
            }
            if (this.queryName != null) {
                context.addNamedQuery(this.queryName, query);
            }
        }
        return query;
    }

    protected abstract Query doToQuery(QueryShardContext var1) throws IOException;

    public final QB queryName(String queryName) {
        this.queryName = queryName;
        return (QB)this;
    }

    @Override
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public final float boost() {
        return this.boost;
    }

    protected final void checkNegativeBoost(float boost) {
        if (Float.compare(boost, 0.0f) < 0) {
            throw new IllegalArgumentException("negative [boost] are not allowed in [" + this.toString() + "], use a value between 0 and 1 to deboost");
        }
    }

    public final QB boost(float boost) {
        this.checkNegativeBoost(boost);
        this.boost = boost;
        return (QB)this;
    }

    protected final QueryValidationException addValidationError(String validationError, QueryValidationException validationException) {
        return QueryValidationException.addValidationError(this.getName(), validationError, validationException);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBuilder other = (AbstractQueryBuilder)obj;
        return Objects.equals(this.queryName, other.queryName) && Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost)) && this.doEquals(other);
    }

    protected abstract boolean doEquals(QB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.queryName, Float.valueOf(this.boost), this.doHashCode());
    }

    protected abstract int doHashCode();

    static Object maybeConvertToBytesRef(Object obj) {
        if (obj instanceof String) {
            return BytesRefs.toBytesRef(obj);
        }
        if (obj instanceof CharBuffer) {
            return new BytesRef((CharBuffer)obj);
        }
        if (obj instanceof BigInteger) {
            return BytesRefs.toBytesRef(obj);
        }
        return obj;
    }

    static Object maybeConvertToString(Object obj) {
        if (obj instanceof BytesRef) {
            return ((BytesRef)obj).utf8ToString();
        }
        if (obj instanceof CharBuffer) {
            return new BytesRef((CharBuffer)obj).utf8ToString();
        }
        return obj;
    }

    static Collection<Query> toQueries(Collection<QueryBuilder> queryBuilders, QueryShardContext context) throws QueryShardException, IOException {
        ArrayList<Query> queries = new ArrayList<Query>(queryBuilders.size());
        for (QueryBuilder queryBuilder : queryBuilders) {
            Query query = queryBuilder.rewrite(context).toQuery(context);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    @Override
    public String getName() {
        return this.getWriteableName();
    }

    static void writeQueries(StreamOutput out, List<? extends QueryBuilder> queries) throws IOException {
        out.writeVInt(queries.size());
        for (QueryBuilder queryBuilder : queries) {
            out.writeNamedWriteable(queryBuilder);
        }
    }

    static List<QueryBuilder> readQueries(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>(size);
        for (int i = 0; i < size; ++i) {
            queries.add(in.readNamedWriteable(QueryBuilder.class));
        }
        return queries;
    }

    @Override
    public final QueryBuilder rewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewritten = this.doRewrite(queryShardContext);
        if (rewritten == this) {
            return rewritten;
        }
        if (this.queryName() != null && rewritten.queryName() == null) {
            rewritten.queryName(this.queryName());
        }
        if (this.boost() != 1.0f && rewritten.boost() == 1.0f) {
            rewritten.boost(this.boost());
        }
        return rewritten;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
    }

    public static QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        QueryBuilder result;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, must start with start_object", new Object[0]);
        }
        if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
            throw new IllegalArgumentException("query malformed, empty clause found at [" + parser.getTokenLocation() + "]");
        }
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, no field after start_object", new Object[0]);
        }
        String queryName = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] query malformed, no start_object after query name", new Object[0]);
        }
        try {
            result = parser.namedObject(QueryBuilder.class, queryName, null);
        }
        catch (NamedObjectNotFoundException e) {
            String message = String.format(Locale.ROOT, "unknown query [%s]%s", queryName, SuggestingErrorOnUnknown.suggest(queryName, e.getCandidates()));
            throw new ParsingException(new XContentLocation(e.getLineNumber(), e.getColumnNumber()), message, e, new Object[0]);
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + parser.currentToken() + "]", new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + parser.currentToken() + "]", new Object[0]);
        }
        return result;
    }

    protected static <T> T requireValue(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    protected static void throwParsingExceptionOnMultipleFields(String queryName, XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
        if (processedFieldName != null) {
            throw new ParsingException(contentLocation, "[" + queryName + "] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
        }
    }

    protected static void declareStandardFields(AbstractObjectParser<? extends QueryBuilder, ?> parser) {
        parser.declareFloat(QueryBuilder::boost, BOOST_FIELD);
        parser.declareString(QueryBuilder::queryName, NAME_FIELD);
    }

    public final String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }
}

