/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LatLonShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.Explicit;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeometryParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapeRelation;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.AbstractGeoShapeIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoShapeIndexer;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoShapeParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoShapeQueryable;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.VectorGeoShapeQueryProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class GeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry, Geometry> {
    private static final Logger logger = LogManager.getLogger(GeoShapeFieldMapper.class);
    public static final String CONTENT_TYPE = "geo_shape";
    public static final FieldType FIELD_TYPE = new FieldType();

    public GeoShapeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
    }

    @Override
    protected void addStoredFields(ParseContext context, Geometry geometry) {
    }

    @Override
    protected void addDocValuesFields(String name, Geometry geometry, List<IndexableField> indexableFields, ParseContext context) {
        if (context.indexSettings().getIndexVersionCreated().onOrAfter(Version.V_2_9_0)) {
            Field[] fieldsArray = new Field[indexableFields.size()];
            fieldsArray = indexableFields.toArray(fieldsArray);
            context.doc().add(LatLonShape.createDocValueField(name, fieldsArray));
        } else {
            logger.warn("The index was created with Version : {}, for geoshape doc values to work index must be created with OpenSearch Version : {} or above", (Object)context.indexSettings().getIndexVersionCreated(), (Object)Version.V_2_9_0);
        }
    }

    @Override
    protected void addMultiFields(ParseContext context, Geometry geometry) {
    }

    @Override
    protected void mergeGeoOptions(AbstractShapeGeometryFieldMapper<?, ?> mergeWith, List<String> conflicts) {
        if (mergeWith instanceof LegacyGeoShapeFieldMapper) {
            LegacyGeoShapeFieldMapper legacy = (LegacyGeoShapeFieldMapper)mergeWith;
            throw new IllegalArgumentException("[" + this.fieldType().name() + "] with field mapper [" + this.fieldType().typeName() + "] using [BKD] strategy cannot be merged with [" + legacy.fieldType().typeName() + "] with [" + legacy.fieldType().strategy() + "] strategy");
        }
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static {
        FIELD_TYPE.setDimensions(7, 4, 4);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }

    public static class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry, Geometry>
    implements GeoShapeQueryable {
        private final VectorGeoShapeQueryProcessor queryProcessor = new VectorGeoShapeQueryProcessor();

        public GeoShapeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, false, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, relation, context);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractGeoShapeIndexFieldData.Builder(this.name(), CoreValuesSourceType.GEO_SHAPE);
        }
    }

    public static final class TypeParser
    extends AbstractShapeGeometryFieldMapper.TypeParser {
        @Override
        protected AbstractShapeGeometryFieldMapper.Builder newBuilder(String name, Map<String, Object> params) {
            if (params.containsKey("deprecated_parameters")) {
                return new LegacyGeoShapeFieldMapper.Builder(name, (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get("deprecated_parameters"));
            }
            return new Builder(name);
        }
    }

    public static class Builder
    extends AbstractShapeGeometryFieldMapper.Builder<Builder, GeoShapeFieldType> {
        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.hasDocValues = true;
            this.builder = this;
        }

        private GeoShapeFieldType buildFieldType(Mapper.BuilderContext context) {
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, this.meta);
            GeometryParser geometryParser = new GeometryParser(ft.orientation.getAsBoolean(), this.coerce().value(), this.ignoreZValue().value());
            ft.setGeometryParser(new GeoShapeParser(geometryParser));
            ft.setGeometryIndexer(new GeoShapeIndexer(this.orientation().value().getAsBoolean(), this.buildFullName(context)));
            ft.setOrientation(this.orientation == null ? AbstractShapeGeometryFieldMapper.Defaults.ORIENTATION.value() : this.orientation);
            return ft;
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.buildFieldType(context), this.ignoreMalformed(context), this.coerce(context), this.ignoreZValue(), this.orientation(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

