/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Fields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafMetaData;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFieldVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermVectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Uid;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;

public final class TranslogLeafReader
extends LeafReader {
    private final Translog.Index operation;
    private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
    private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
    private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
    public static Set<String> ALL_FIELD_NAMES = Sets.newHashSet(TranslogLeafReader.FAKE_SOURCE_FIELD.name, TranslogLeafReader.FAKE_ROUTING_FIELD.name, TranslogLeafReader.FAKE_ID_FIELD.name);

    TranslogLeafReader(Translog.Index operation) {
        this.operation = operation;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Terms terms(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericDocValues getNormValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointValues getPointValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkIntegrity() {
    }

    @Override
    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Fields getTermVectors(int docID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermVectors termVectors() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numDocs() {
        return 1;
    }

    @Override
    public int maxDoc() {
        return 1;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.storedFields().document(docID, visitor);
    }

    @Override
    public StoredFields storedFields() throws IOException {
        return new StoredFields(){

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (docID != 0) {
                    throw new IllegalArgumentException("no such doc ID " + docID);
                }
                if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                    assert (TranslogLeafReader.this.operation.source().toBytesRef().offset == 0);
                    assert (TranslogLeafReader.this.operation.source().toBytesRef().length == TranslogLeafReader.this.operation.source().toBytesRef().bytes.length);
                    visitor.binaryField(FAKE_SOURCE_FIELD, TranslogLeafReader.this.operation.source().toBytesRef().bytes);
                }
                if (TranslogLeafReader.this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                    visitor.stringField(FAKE_ROUTING_FIELD, TranslogLeafReader.this.operation.routing());
                }
                if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                    BytesRef bytesRef = Uid.encodeId(TranslogLeafReader.this.operation.id());
                    byte[] id = new byte[bytesRef.length];
                    System.arraycopy(bytesRef.bytes, bytesRef.offset, id, 0, bytesRef.length);
                    visitor.binaryField(FAKE_ID_FIELD, id);
                }
            }
        };
    }

    @Override
    protected void doClose() {
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.getFloatVectorValues(field);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.getByteVectorValues(field);
    }

    @Override
    public TopDocs searchNearestVectors(String field, byte[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        throw new UnsupportedOperationException();
    }
}

