/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.ReplicationStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteSegmentStats;

public class SegmentsStats
implements Writeable,
ToXContentFragment {
    private long count;
    private long indexWriterMemoryInBytes;
    private long versionMapMemoryInBytes;
    private long maxUnsafeAutoIdTimestamp = Long.MIN_VALUE;
    private long bitsetMemoryInBytes;
    private final Map<String, Long> fileSizes;
    private final RemoteSegmentStats remoteSegmentStats;
    private static final ByteSizeValue ZERO_BYTE_SIZE_VALUE = new ByteSizeValue(0L);
    private final ReplicationStats replicationStats;
    private static final Map<String, String> FILE_DESCRIPTIONS = Map.ofEntries(Map.entry("si", "Segment Info"), Map.entry("fnm", "Fields"), Map.entry("fdx", "Field Index"), Map.entry("fdt", "Field Data"), Map.entry("tim", "Term Dictionary"), Map.entry("tip", "Term Index"), Map.entry("doc", "Frequencies"), Map.entry("pos", "Positions"), Map.entry("pay", "Payloads"), Map.entry("nvd", "Norms"), Map.entry("nvm", "Norms"), Map.entry("dii", "Points"), Map.entry("dim", "Points"), Map.entry("dvd", "DocValues"), Map.entry("dvm", "DocValues"), Map.entry("tvx", "Term Vector Index"), Map.entry("tvd", "Term Vector Documents"), Map.entry("tvf", "Term Vector Fields"), Map.entry("liv", "Live Documents"));

    public SegmentsStats() {
        this.fileSizes = new HashMap<String, Long>();
        this.remoteSegmentStats = new RemoteSegmentStats();
        this.replicationStats = new ReplicationStats();
    }

    public SegmentsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
        }
        this.indexWriterMemoryInBytes = in.readLong();
        this.versionMapMemoryInBytes = in.readLong();
        this.bitsetMemoryInBytes = in.readLong();
        this.maxUnsafeAutoIdTimestamp = in.readLong();
        this.fileSizes = in.readMap(StreamInput::readString, StreamInput::readLong);
        if (in.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.remoteSegmentStats = in.readOptionalWriteable(RemoteSegmentStats::new);
            this.replicationStats = in.readOptionalWriteable(ReplicationStats::new);
        } else {
            this.remoteSegmentStats = new RemoteSegmentStats();
            this.replicationStats = new ReplicationStats();
        }
    }

    public void add(long count) {
        this.count += count;
    }

    public void addIndexWriterMemoryInBytes(long indexWriterMemoryInBytes) {
        this.indexWriterMemoryInBytes += indexWriterMemoryInBytes;
    }

    public void addVersionMapMemoryInBytes(long versionMapMemoryInBytes) {
        this.versionMapMemoryInBytes += versionMapMemoryInBytes;
    }

    void updateMaxUnsafeAutoIdTimestamp(long maxUnsafeAutoIdTimestamp) {
        this.maxUnsafeAutoIdTimestamp = Math.max(maxUnsafeAutoIdTimestamp, this.maxUnsafeAutoIdTimestamp);
    }

    public void addBitsetMemoryInBytes(long bitsetMemoryInBytes) {
        this.bitsetMemoryInBytes += bitsetMemoryInBytes;
    }

    public void addRemoteSegmentStats(RemoteSegmentStats remoteSegmentStats) {
        this.remoteSegmentStats.add(remoteSegmentStats);
    }

    public void addReplicationStats(ReplicationStats replicationStats) {
        this.replicationStats.add(replicationStats);
    }

    public void addFileSizes(Map<String, Long> newFileSizes) {
        newFileSizes.forEach((k, v) -> this.fileSizes.merge((String)k, (Long)v, (a, b) -> {
            assert (a != null);
            assert (b != null);
            return Math.addExact(a, b);
        }));
    }

    public void add(SegmentsStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.updateMaxUnsafeAutoIdTimestamp(mergeStats.maxUnsafeAutoIdTimestamp);
        this.add(mergeStats.count);
        this.addIndexWriterMemoryInBytes(mergeStats.indexWriterMemoryInBytes);
        this.addVersionMapMemoryInBytes(mergeStats.versionMapMemoryInBytes);
        this.addBitsetMemoryInBytes(mergeStats.bitsetMemoryInBytes);
        this.addFileSizes(mergeStats.fileSizes);
        this.addRemoteSegmentStats(mergeStats.remoteSegmentStats);
        this.addReplicationStats(mergeStats.replicationStats);
    }

    public long getCount() {
        return this.count;
    }

    public long getIndexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMemory() {
        return new ByteSizeValue(this.indexWriterMemoryInBytes);
    }

    public long getVersionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    public ByteSizeValue getVersionMapMemory() {
        return new ByteSizeValue(this.versionMapMemoryInBytes);
    }

    public long getBitsetMemoryInBytes() {
        return this.bitsetMemoryInBytes;
    }

    public ByteSizeValue getBitsetMemory() {
        return new ByteSizeValue(this.bitsetMemoryInBytes);
    }

    public Map<String, Long> getFileSizes() {
        return Collections.unmodifiableMap(this.fileSizes);
    }

    public RemoteSegmentStats getRemoteSegmentStats() {
        return this.remoteSegmentStats;
    }

    public ReplicationStats getReplicationStats() {
        return this.replicationStats;
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segments");
        builder.field("count", this.count);
        builder.humanReadableField("memory_in_bytes", "memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("terms_memory_in_bytes", "terms_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("stored_fields_memory_in_bytes", "stored_fields_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("term_vectors_memory_in_bytes", "term_vectors_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("norms_memory_in_bytes", "norms_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("points_memory_in_bytes", "points_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("doc_values_memory_in_bytes", "doc_values_memory", ZERO_BYTE_SIZE_VALUE);
        builder.humanReadableField("index_writer_memory_in_bytes", "index_writer_memory", this.getIndexWriterMemory());
        builder.humanReadableField("version_map_memory_in_bytes", "version_map_memory", this.getVersionMapMemory());
        builder.humanReadableField("fixed_bit_set_memory_in_bytes", "fixed_bit_set", this.getBitsetMemory());
        builder.field("max_unsafe_auto_id_timestamp", this.maxUnsafeAutoIdTimestamp);
        this.remoteSegmentStats.toXContent(builder, params);
        this.replicationStats.toXContent(builder, params);
        builder.startObject("file_sizes");
        for (Map.Entry<String, Long> entry : this.fileSizes.entrySet()) {
            builder.startObject(entry.getKey());
            builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue(entry.getValue()));
            builder.field("description", FILE_DESCRIPTIONS.getOrDefault(entry.getKey(), "Others"));
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
        }
        out.writeLong(this.indexWriterMemoryInBytes);
        out.writeLong(this.versionMapMemoryInBytes);
        out.writeLong(this.bitsetMemoryInBytes);
        out.writeLong(this.maxUnsafeAutoIdTimestamp);
        out.writeMap(this.fileSizes, StreamOutput::writeString, StreamOutput::writeLong);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalWriteable(this.remoteSegmentStats);
            out.writeOptionalWriteable(this.replicationStats);
        }
    }

    public void clearFileSizes() {
        this.fileSizes.clear();
    }

    @Deprecated
    public ByteSizeValue getZeroMemory() {
        return ZERO_BYTE_SIZE_VALUE;
    }

    static final class Fields {
        static final String SEGMENTS = "segments";
        static final String COUNT = "count";
        static final String MEMORY = "memory";
        static final String MEMORY_IN_BYTES = "memory_in_bytes";
        static final String TERMS_MEMORY = "terms_memory";
        static final String TERMS_MEMORY_IN_BYTES = "terms_memory_in_bytes";
        static final String STORED_FIELDS_MEMORY = "stored_fields_memory";
        static final String STORED_FIELDS_MEMORY_IN_BYTES = "stored_fields_memory_in_bytes";
        static final String TERM_VECTORS_MEMORY = "term_vectors_memory";
        static final String TERM_VECTORS_MEMORY_IN_BYTES = "term_vectors_memory_in_bytes";
        static final String NORMS_MEMORY = "norms_memory";
        static final String NORMS_MEMORY_IN_BYTES = "norms_memory_in_bytes";
        static final String POINTS_MEMORY = "points_memory";
        static final String POINTS_MEMORY_IN_BYTES = "points_memory_in_bytes";
        static final String DOC_VALUES_MEMORY = "doc_values_memory";
        static final String DOC_VALUES_MEMORY_IN_BYTES = "doc_values_memory_in_bytes";
        static final String INDEX_WRITER_MEMORY = "index_writer_memory";
        static final String INDEX_WRITER_MEMORY_IN_BYTES = "index_writer_memory_in_bytes";
        static final String VERSION_MAP_MEMORY = "version_map_memory";
        static final String VERSION_MAP_MEMORY_IN_BYTES = "version_map_memory_in_bytes";
        static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP = "max_unsafe_auto_id_timestamp";
        static final String FIXED_BIT_SET = "fixed_bit_set";
        static final String FIXED_BIT_SET_MEMORY_IN_BYTES = "fixed_bit_set_memory_in_bytes";
        static final String FILE_SIZES = "file_sizes";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String DESCRIPTION = "description";

        Fields() {
        }
    }
}

